<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:fo="http://www.w3.org/1999/XSL/Format">
    
    <xsl:import href="view://stylesheets/io/docbook2fo.xsl" />
    
    <xsl:param name="mainOrientation" select="'portrait'"/>
    
    <xsl:variable name="watermark-size">25</xsl:variable>
    
    <xsl:template match="/*">
        <xsl:call-template name="root"/>
    </xsl:template>
    
    <xsl:template name="root">
        <fo:root>
            <fo:layout-master-set>
                <xsl:call-template name="master-pages"/>
            </fo:layout-master-set>
            
            <fo:declarations>
                <x:xmpmeta xmlns:x="adobe:ns:meta/">
                    <rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
                        <rdf:Description xmlns:dc="http://purl.org/dc/elements/1.1/">
                            <dc:title><xsl:call-template name="property-title"/></dc:title>
                            <dc:creator><i18n:text i18n:catalogue="application" i18n:key="APPLICATION_PRODUCT_LABEL"/></dc:creator>
                        </rdf:Description>
                    </rdf:RDF>
                </x:xmpmeta>
            </fo:declarations>
            
            <!--  The bookmark tree -->
            <xsl:call-template name="menu-items"/>
            
            <!-- Contents -->
            <xsl:call-template name="sequences"/>
        </fo:root>
    </xsl:template>
    
    <xsl:template name="master-pages">
        <xsl:call-template name="master-pages-format">
            <xsl:with-param name="format" select="'a4'"/>
            <xsl:with-param name="short" select="210"/>
            <xsl:with-param name="long" select="297"/>
        </xsl:call-template>
        <xsl:call-template name="master-pages-format">
            <xsl:with-param name="format" select="'a3'"/>
            <xsl:with-param name="short" select="297"/>
            <xsl:with-param name="long" select="420"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="master-pages-format">
        <xsl:param name="format"/>
        <xsl:param name="short"/>
        <xsl:param name="long"/>
        
        <xsl:call-template name="master-page">
            <xsl:with-param name="orientation" select="'landscape'"/>
            <xsl:with-param name="format" select="$format"/>
            <xsl:with-param name="width" select="$long"/>
            <xsl:with-param name="height" select="$short"/>
        </xsl:call-template>
        <xsl:call-template name="master-page">
            <xsl:with-param name="orientation" select="'portrait'"/>
            <xsl:with-param name="format" select="$format"/>
            <xsl:with-param name="width" select="$short"/>
            <xsl:with-param name="height" select="$long"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="master-page">
        <xsl:param name="orientation"/>
        <xsl:param name="format"/>
        <xsl:param name="width"/>
        <xsl:param name="height"/>
        
        <fo:simple-page-master master-name="{$orientation}-{$format}" page-width="{$width}mm" page-height="{$height}mm" margin-left="1cm" margin-right="1cm" margin-top="1cm" margin-bottom="1cm">
            <xsl:call-template name="page-regions">
                <xsl:with-param name="orientation" select="$orientation"/>
                <xsl:with-param name="format" select="$format"/>
            </xsl:call-template>
        </fo:simple-page-master>
    </xsl:template>
    
    <xsl:template name="sequences">
        <xsl:call-template name="main-sequence"/>
    </xsl:template>
    
    <xsl:template name="main-sequence">
        <fo:page-sequence master-reference="{$mainOrientation}-a4" force-page-count="no-force" font-size="10pt" line-height="1.5">
            <xsl:call-template name="sequence-id"/>
            <xsl:call-template name="flows"/>
        </fo:page-sequence>
    </xsl:template>
    
    <xsl:template name="sequence-id">
        <xsl:attribute name="id">last-sequence</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="page-regions">
        <xsl:param name="orientation"/>
        <xsl:param name="format"/>
        
        <fo:region-body margin-top="0" margin-bottom="12mm" />
        <fo:region-before extent="0cm" region-name="watermark-{$orientation}-{$format}"/>
        <fo:region-after extent="1cm" region-name="footer" />
    </xsl:template>
    
    <xsl:template name="menu-items"/>
    
    <xsl:template name="flows">
        <xsl:call-template name="xsl-region-before"/>
        <xsl:call-template name="xsl-region-after"/>
        <xsl:call-template name="main-flow"/>
    </xsl:template>
    
    <!-- // Header -->
    <xsl:template name="xsl-region-before"/>
    
    <xsl:template name="watermark">
        <xsl:param name="format"/>
        <xsl:param name="orientation"/>
        
        <fo:static-content flow-name="watermark-{$orientation}-{$format}">
            <fo:block>
                <xsl:choose>
                    <xsl:when test="$format = 'a3'">
                        <xsl:call-template name="watermark-object-orientation">
                            <xsl:with-param name="orientation" select="$orientation"/>
                            <xsl:with-param name="short" select="297"/>
                            <xsl:with-param name="long" select="420"/>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="watermark-object-orientation">
                            <xsl:with-param name="orientation" select="$orientation"/>
                            <xsl:with-param name="short" select="210"/>
                            <xsl:with-param name="long" select="297"/>
                        </xsl:call-template>
                    </xsl:otherwise>
                </xsl:choose>
            </fo:block>
        </fo:static-content>
    </xsl:template>
    
    <xsl:template name="watermark-object-orientation">
        <xsl:param name="orientation"/>
        <xsl:param name="short"/>
        <xsl:param name="long"/>
        
        <xsl:choose>
            <xsl:when test="$orientation = 'portrait'">
                <xsl:call-template name="watermark-object">
                    <xsl:with-param name="width" select="$short"/>
                    <xsl:with-param name="height" select="$long"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="watermark-object">
                    <xsl:with-param name="width" select="$long"/>
                    <xsl:with-param name="height" select="$short"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="watermark-object">
        <xsl:param name="width"/>
        <xsl:param name="height"/>
        
        <fo:instream-foreign-object content-width="{$width}mm" content-height="{$height}mm" dominant-baseline="central">
            <svg width="{$width}" height="{$height}" xmlns="http://www.w3.org/2000/svg" version="1.1">
                <text x="{$width div 2}" y="{$height div 2}" transform="rotate(-${$width div 3} {$width div 2} {$height div 2})" font-size="{$watermark-size}" fill="lightgrey" dominant-baseline="central" text-anchor="middle">
                    <xsl:call-template name="watermark-label"/>
                </text>
            </svg>
        </fo:instream-foreign-object>
    </xsl:template>
    
    <xsl:template name="watermark-label" />
    <!-- // END Header -->
    
    <!-- // Footer -->
    <xsl:template name="xsl-region-after">
        <fo:static-content flow-name="footer">
            <fo:block font-size="80%">
                <fo:table table-layout="fixed">
                    <fo:table-column column-width="5cm"/>
                    <fo:table-column />
                    <fo:table-column column-width="5cm"/>
                    <fo:table-body>
                        <fo:table-row display-align="center">
                            <fo:table-cell text-align="left" margin="0">
                                <fo:block><xsl:call-template name="date-footer" /></fo:block>
                            </fo:table-cell>
                            <fo:table-cell text-align="center">
                                <fo:block><xsl:call-template name="footer"/></fo:block>
                            </fo:table-cell>
                            <fo:table-cell text-align="right">
                                <fo:block>
                                    <fo:page-number />/<fo:page-number-citation-last ref-id="last-sequence"/>
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                    </fo:table-body>
                </fo:table>
            </fo:block>
        </fo:static-content> 
    </xsl:template>
    
    <xsl:template name="date-footer">
        <i18n:translate>
            <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_DATE"/>
            <i18n:param><i18n:date-time pattern="dd/MM/yyyy HH:mm" /></i18n:param>
        </i18n:translate>
    </xsl:template>
    
    <xsl:template name="footer">
        <xsl:call-template name="property-title"/>
    </xsl:template>
    <!-- // END Footer -->
    
    <xsl:template name="main-flow">
        <fo:flow flow-name="xsl-region-body">
            <xsl:call-template name="body"/>
        </fo:flow>
    </xsl:template>
    
    <!-- Newline to block tag. -->
    <xsl:template name="text.nl2block">
        <xsl:param name="input"/>
        <xsl:param name="s1"><xsl:text>
</xsl:text></xsl:param>
        
        <xsl:choose>
            <xsl:when test="contains($input, $s1)">
                <xsl:variable name="rest">
                    <xsl:call-template name="text.nl2block">
                        <xsl:with-param name="input" select="substring-after($input, $s1)"/>
                        <xsl:with-param name="s1" select="$s1"/>
                    </xsl:call-template>
                </xsl:variable>
                <xsl:value-of select="substring-before($input, $s1)"/>
                <fo:block />
                <xsl:copy-of select="$rest"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$input"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>
