/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.course;

import java.util.Map;

import org.ametys.cms.repository.Content;
import org.ametys.odf.content.CopyODFContentUpdater;
import org.ametys.odf.course.Course;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;

/**
 * Copy updater to remove the 'etape porteuse' on {@link Course}.
 */
public class EtapePorteuseCourseCopyUpdater extends AbstractLogEnabled implements CopyODFContentUpdater
{
    @Override
    public void updateContents(String initialCatalogName, String newCatalogName, Map<Content, Content> copiedContents, Content targetParentContent)
    {
        for (Content copiedContent : copiedContents.values())
        {
            if (copiedContent instanceof Course copiedCourse)
            {
                copiedCourse.removeValue("etapePorteuse");
                if (copiedCourse.needsSave())
                {
                    copiedCourse.saveChanges();

                    // Create a new version
                    copiedCourse.checkpoint();
                }
            }
        }
    }
}
