/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.restriction;

import org.ametys.cms.model.restrictions.RestrictedModelItem;
import org.ametys.cms.repository.Content;
import org.ametys.runtime.config.Config;

/**
 * Restrictions for skills that should be available only when the skills config parameter is active.
 */
// FIXME Solution not ideal, we should not have skills in the model when skill is disabled
public class SkillsMCCSessionRestriction extends RepeaterWithEducationalPathRestriction
{
    @Override
    public RestrictionResult canRead(Content content, RestrictedModelItem modelItem)
    {
        boolean isSkillsEnabled = Config.getInstance().getValue("odf.skills.enabled");
        if (!isSkillsEnabled)
        {
            return RestrictionResult.FALSE;
        }
        else
        {
            return super.canRead(content, modelItem);
        }
    }

    @Override
    public RestrictionResult canWrite(Content content, RestrictedModelItem modelItem)
    {
        boolean isSkillsEnabled = Config.getInstance().getValue("odf.skills.enabled");
        if (!isSkillsEnabled)
        {
            return RestrictionResult.FALSE;
        }
        else
        {
            return super.canWrite(content, modelItem);
        }
    }
}
