/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.rule.export;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.environment.Request;

import org.ametys.odf.catalog.CatalogsManager;
import org.ametys.odf.enumeration.OdfReferenceTableHelper;
import org.ametys.runtime.config.Config;

/**
 * This action set the thematic name as attachment in the header
 */
public class SetThematicHeaderAction extends AbstractSetContentDispositionHeaderAction implements Serviceable
{
    /** The catalogs manager */
    protected CatalogsManager _catalogsManager;
    /** The ODF reference table helper */
    protected OdfReferenceTableHelper _odfRefTableHelper;
    
    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        _catalogsManager = (CatalogsManager) serviceManager.lookup(CatalogsManager.ROLE);
        _odfRefTableHelper = (OdfReferenceTableHelper) serviceManager.lookup(OdfReferenceTableHelper.ROLE);
    }
    
    @Override
    protected String buildFilename(Request request, Parameters parameters) throws Exception
    {
        String catalog = request.getParameter("catalog");
        String degree = request.getParameter("degree");
        String format = parameters.getParameter("format");
        
        StringBuilder filename = new StringBuilder();
        filename.append("Règles standard - "); // File name in ODF 
        filename.append(_odfRefTableHelper.getItemLabel(degree, Config.getInstance().getValue("odf.programs.lang")));
        filename.append(" - ");
        filename.append(_catalogsManager.getCatalog(catalog).getTitle());
        filename.append(".").append(format);
        return filename.toString();
    }
}
