/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.clientsideelement;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.program.AbstractProgramPart;
import org.ametys.plugins.odfpilotage.clientsideelement.MCCWorkflowClientSideElement;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.ametys.runtime.config.Config;

public class OrgunitMCCWorkflowClientSideElement
extends MCCWorkflowClientSideElement {
    @Callable(rights={"ODF_Pilotage_Global_MCC_Orgunit_Validated_Rights"}, paramIndex=0, rightContext="right.assignment.context.content")
    public Map<String, Object> validateOrgunitMCC(String ouId, String catalogName, String validationDate, String comment) {
        List<String> containerIds = this._getYears(ouId, catalogName);
        return this.validateOrgunitMCC(containerIds, null, validationDate, comment, Map.of());
    }

    @Callable(rights={"ODF_Pilotage_Global_CFVU_MCC_Validated_Rights"}, paramIndex=0, rightContext="right.assignment.context.content")
    public Map<String, Object> validateMCCForCVFU(String ouId, String catalogName, String validationDate, String comment, Map<String, Object> contextualParameters) {
        List<String> containerIds = this._getYears(ouId, catalogName);
        return this.validateMCCForCFVU(containerIds, null, validationDate, comment, contextualParameters);
    }

    private List<String> _getYears(String ouId, String catalogName) {
        OrgUnit ou = (OrgUnit)this._resolver.resolveById(ouId);
        return this._odfHelper.getProgramsFromOrgUnit(ou, catalogName, (String)Config.getInstance().getValue("odf.programs.lang"), false).stream().map(arg_0 -> ((ODFHelper)this._odfHelper).getYears(arg_0)).flatMap(Collection::stream).filter(y -> this._checkOrgUnit((AbstractProgramPart)y, ouId)).map(SimpleAmetysObject::getId).toList();
    }

    private boolean _checkOrgUnit(AbstractProgramPart programPart, String ouId) {
        if (programPart.getOrgUnits().contains(ouId)) {
            return true;
        }
        List parentProgramItems = this._odfHelper.getParentProgramItems((ProgramItem)programPart);
        for (ProgramItem parentProgramItem : parentProgramItems) {
            AbstractProgramPart parentProgramPart;
            if (!(parentProgramItem instanceof AbstractProgramPart) || !this._checkOrgUnit(parentProgramPart = (AbstractProgramPart)parentProgramItem, ouId)) continue;
            return true;
        }
        return false;
    }
}

