<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:odf="org.ametys.odf.OdfXSLTHelper"
                              exclude-result-prefixes="odf">
    
        <xsl:variable name="multi-value-separator"><xsl:text>
</xsl:text></xsl:variable>
    
    <xsl:template match="/" >
        <csv>       
            <xsl:call-template name="table-head" />
            <xsl:call-template name="table-body" />
        </csv>
    </xsl:template>
    
    <xsl:template name="table-head">
        <row>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_EXTRACT_MCC_SESSIONS_COLUMN_PROGRAM_CODE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_EXTRACT_MCC_SESSIONS_COLUMN_PROGRAM_TITLE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_EXTRACT_MCC_SESSIONS_COLUMN_SUBPROGRAM_CODE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_EXTRACT_MCC_SESSIONS_COLUMN_SUBPROGRAM_TITLE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_EXTRACT_MCC_SESSIONS_COLUMN_YEAR_CODE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_EXTRACT_MCC_SESSIONS_COLUMN_YEAR_TITLE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_EXTRACT_MCC_SESSIONS_COLUMN_SEMESTER_CODE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_EXTRACT_MCC_SESSIONS_COLUMN_SEMESTER_TITLE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_EXTRACT_MCC_SESSIONS_COLUMN_UE_CODE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_EXTRACT_MCC_SESSIONS_COLUMN_UE_TITLE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_EXTRACT_MCC_SESSIONS_COLUMN_EC_CODE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_EXTRACT_MCC_SESSIONS_COLUMN_EC_TITLE"/></cell>
            <xsl:apply-templates select="//column" mode="head"/>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_EXTRACT_MCC_SESSIONS_COLUMN_SESSION"/></cell>
        </row>
    </xsl:template>
    
    <xsl:template match="column" mode="head">
        <cell><xsl:value-of select="label" /></cell>
    </xsl:template>
    
    <xsl:template name="table-body">
        <xsl:apply-templates select="//course" mode="body"/>
    </xsl:template>
    
    <xsl:template match="course[mcc/mccSession1/entry or mcc/mccSession2/entry]" mode="body">
        <xsl:apply-templates select="mcc/mccSession1/entry" mode="row">
            <xsl:with-param name="sessionName">mccSession1</xsl:with-param>
            <xsl:with-param name="sessionKey">PLUGINS_ODF_PILOTAGE_COURSE_MCC_SESSION1_LABEL</xsl:with-param>
            <xsl:with-param name="course" select="." />
        </xsl:apply-templates>
        
        <xsl:apply-templates select="mcc/mccSession2/entry" mode="row">
            <xsl:with-param name="sessionName">mccSession2</xsl:with-param>
            <xsl:with-param name="sessionKey">PLUGINS_ODF_PILOTAGE_COURSE_MCC_SESSION2_LABEL</xsl:with-param>
            <xsl:with-param name="course" select="." />
        </xsl:apply-templates>
    </xsl:template>
    
    <!-- The course does not have any sessions -->
    <xsl:template match="course" mode="body">
        <row>
            <xsl:apply-templates select="." mode="common"/>
            
            <xsl:apply-templates select="//column" mode="cell">
                <xsl:with-param name="course" select="." />
            </xsl:apply-templates>
            
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_EXTRACT_MCC_SESSIONS_COLUMN_NO_SESSION"/></cell>
        </row>
    </xsl:template>
    
    <xsl:template match="course" mode="common">
        <cell><xsl:value-of select="programCode"/></cell>
        <cell><xsl:value-of select="programTitle"/></cell>
        <cell><xsl:value-of select="subProgramCode"/></cell>
        <cell><xsl:value-of select="subProgramTitle"/></cell>
        <cell><xsl:value-of select="yearCode"/></cell>
        <cell><xsl:value-of select="yearTitle"/></cell>
        <cell><xsl:value-of select="semesterCode"/></cell>
        <cell><xsl:value-of select="semesterTitle"/></cell>
        <cell><xsl:value-of select="level1CourseListCode"/></cell>
        <cell><xsl:value-of select="level1CourseListTitle"/></cell>
        <cell><xsl:value-of select="level2CourseListCode"/></cell>
        <cell><xsl:value-of select="level2CourseListTitle"/></cell>
    </xsl:template>
    
    <xsl:template match="entry" mode="row" >
        <xsl:param name="sessionName" />
        <xsl:param name="sessionKey" />
        <xsl:param name="course" />
        
        <row>
            <xsl:apply-templates select="$course" mode="common"/>
            
            <xsl:apply-templates select="//column" mode="cell">
                <xsl:with-param name="course" select="$course" />
                <xsl:with-param name="entry" select="." />
                <xsl:with-param name="sessionName" select="$sessionName" />
            </xsl:apply-templates>
            
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="{$sessionKey}"/></cell>
        </row>
    </xsl:template>
    
    <!-- Add a MCC session cell -->
    <xsl:template match="column[@pathFromSession]" mode="cell" >
        <xsl:param name="entry" />
        <xsl:param name="sessionName" />
        <xsl:variable name="sessionPath"><xsl:value-of select="concat($sessionName, concat('/', @pathFromSession))" /></xsl:variable>
        
        <cell>
            <xsl:if test="$entry">
                <xsl:apply-templates select="$entry/*[@modelPath = $sessionPath]" mode="value" />
            </xsl:if>
        </cell>
    </xsl:template>
    
    <!-- Add a course cell -->
    <xsl:template match="column" mode="cell" >
        <xsl:param name="course" />
        <xsl:variable name="path" select="@path" />
        
        <cell>
            <xsl:apply-templates select="$course/*[@modelPath = $path]" mode="value" />
        </cell>
    </xsl:template>
    
    <xsl:template match="*[@typeId = 'boolean']" mode="value">
        <xsl:if test="text() = 'true'">X</xsl:if>
    </xsl:template>

    <xsl:template match="*[@typeId = 'content']" mode="value">
        <xsl:value-of select="@title" />
        <xsl:if test="position() != last()"><xsl:value-of select="$multi-value-separator" /></xsl:if>
    </xsl:template>
    
    <xsl:template match="*[@typeId = 'educational-path']" mode="value">
        <xsl:value-of select="odf:getEducationalPathAsString(.)" />
        <xsl:if test="position() != last()"><xsl:value-of select="$multi-value-separator" /></xsl:if>
    </xsl:template>
    
    <xsl:template match="*" mode="value">
        <xsl:value-of select="." />
        <xsl:if test="position() != last()"><xsl:value-of select="$multi-value-separator" /></xsl:if>
    </xsl:template>
</xsl:stylesheet>
