/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.cost.eqtd.impl;

import java.util.Optional;
import org.ametys.plugins.odfpilotage.cost.entity.Groups;
import org.ametys.plugins.odfpilotage.cost.entity.ProgramItemData;
import org.ametys.plugins.odfpilotage.cost.eqtd.AbstractEqTDComputationMode;

public class GroupsMode
extends AbstractEqTDComputationMode {
    @Override
    public Double computeEqTD(ProgramItemData programItemData, Double eqTDCoef) {
        if (eqTDCoef != null) {
            Groups groups = programItemData.getGroups();
            Long nbGroups = Optional.ofNullable(groups.getOverriddenGroups()).or(() -> Optional.ofNullable(groups.getGroupsToOpen())).orElseGet(() -> groups.getComputedGroups());
            Double nbHours = programItemData.getVolumesOfHours().getTotal();
            return eqTDCoef * (double)nbGroups.longValue() * nbHours;
        }
        return 0.0;
    }
}

