/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.report.impl;

import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableDefaultContent;
import org.ametys.core.util.DateUtils;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.coursepart.CoursePart;
import org.ametys.odf.enumeration.OdfReferenceTableEntry;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.odfpilotage.cost.CostComputationComponent;
import org.ametys.plugins.odfpilotage.cost.entity.CostComputationData;
import org.ametys.plugins.odfpilotage.cost.entity.Effectives;
import org.ametys.plugins.odfpilotage.cost.entity.EqTD;
import org.ametys.plugins.odfpilotage.cost.entity.Groups;
import org.ametys.plugins.odfpilotage.cost.entity.NormDetails;
import org.ametys.plugins.odfpilotage.cost.entity.ProgramItemData;
import org.ametys.plugins.odfpilotage.helper.PilotageHelper;
import org.ametys.plugins.odfpilotage.helper.ReportHelper;
import org.ametys.plugins.odfpilotage.report.impl.AbstractReport;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CoutMaquettesReport
extends AbstractReport {
    protected CostComputationComponent _costComputationComponent;
    private int _order;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._costComputationComponent = (CostComputationComponent)((Object)manager.lookup(CostComputationComponent.ROLE));
    }

    @Override
    protected String getType(Map<String, String> reportParameters) {
        return "coutmaquettes";
    }

    @Override
    public String getDefaultOutputFormat() {
        return "xls";
    }

    @Override
    public Set<String> getSupportedOutputFormats() {
        return Set.of("xls", "csv");
    }

    @Override
    public void _saxOrgUnit(ContentHandler handler, String catalog, String lang, String orgUnitId, Map<String, String> reportParameters) {
        OrgUnit orgUnit = (OrgUnit)this._resolver.resolveById(orgUnitId);
        List selectedPrograms = this._odfHelper.getProgramsFromOrgUnit(orgUnit, catalog, lang);
        CostComputationData costData = this._costComputationComponent.computeCostsOnPrograms(selectedPrograms, true);
        try {
            handler.startDocument();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("type", this.getType());
            XMLUtils.startElement((ContentHandler)handler, (String)"report", (Attributes)attrs);
            this._generateReport(handler, costData, orgUnit, lang, catalog);
            XMLUtils.endElement((ContentHandler)handler, (String)"report");
            handler.endDocument();
        }
        catch (Exception e) {
            this.getLogger().error("An error occured while generating 'Co\u00fbt des maquettes' report for orgunit '{}'", (Object)orgUnit.getTitle(), (Object)e);
        }
    }

    private void _generateReport(ContentHandler handler, CostComputationData costData, OrgUnit orgUnit, String lang, String catalog) throws SAXException {
        Map<Program, Object> contentsTree = this._getStructure(orgUnit, lang, catalog);
        if (contentsTree.size() > 0) {
            this._order = 1;
            this._saxTree(handler, contentsTree);
        }
        this._writeColumns(handler, costData);
        this._writeLines(handler, costData);
    }

    private void _saxTree(ContentHandler handler, Map<Program, Object> programTree) throws SAXException {
        for (Map.Entry<Program, Object> programEntry : programTree.entrySet()) {
            if (programEntry.getValue() == null || !(programEntry.getValue() instanceof Map)) continue;
            this._saxCourseFromTree(handler, (Map)programEntry.getValue(), programEntry.getKey());
        }
    }

    private void _saxCourseFromTree(ContentHandler handler, Map<ProgramItem, Object> programTree, Program program) throws SAXException {
        this._saxCourseFromTree(handler, programTree, program, null, null, null, null, null, 1, program.getName());
    }

    private void _saxCourseFromTree(ContentHandler handler, Map<ProgramItem, Object> tree, Program program, SubProgram subprogram, Container containerYear, CourseList list, Integer listPosition, Course parentCourse, int level, String hierarchy) throws SAXException {
        int courseListPosition = 0;
        for (Map.Entry<ProgramItem, Object> entry : tree.entrySet()) {
            ProgramItem child = entry.getKey();
            Map subTree = (Map)entry.getValue();
            String childHierarchy = hierarchy + "/" + child.getName();
            if (child instanceof Course) {
                Course childCourse = (Course)child;
                this._saxCourse(handler, program, subprogram, containerYear, list, listPosition, childCourse, parentCourse, level, subTree.isEmpty(), childHierarchy);
                this._saxCourseFromTree(handler, subTree, program, subprogram, containerYear, list, listPosition, childCourse, level + 1, childHierarchy);
                continue;
            }
            if (child instanceof Program) {
                Program childProgram = (Program)child;
                this._saxCourseFromTree(handler, subTree, childProgram, subprogram, containerYear, list, listPosition, parentCourse, level, childHierarchy);
                continue;
            }
            if (child instanceof Container) {
                Container childContainer = (Container)child;
                String containerNature = this._refTableHelper.getItemCode(childContainer.getNature());
                if ("annee".equals(containerNature)) {
                    this._saxCourseFromTree(handler, subTree, program, subprogram, childContainer, list, listPosition, parentCourse, level, childHierarchy);
                    continue;
                }
                this._saxCourseFromTree(handler, subTree, program, subprogram, containerYear, list, listPosition, parentCourse, level, childHierarchy);
                continue;
            }
            if (child instanceof SubProgram) {
                SubProgram childSubProgram = (SubProgram)child;
                this._saxCourseFromTree(handler, subTree, program, childSubProgram, containerYear, list, listPosition, parentCourse, level, childHierarchy);
                continue;
            }
            if (!(child instanceof CourseList)) continue;
            CourseList childCourseList = (CourseList)child;
            this._saxCourseFromTree(handler, subTree, program, subprogram, containerYear, childCourseList, ++courseListPosition, parentCourse, level, childHierarchy);
        }
    }

    private void _saxCourse(ContentHandler handler, Program program, SubProgram subprogram, Container containerYear, CourseList list, Integer listPosition, Course course, Course parentCourse, int level, boolean lastLevel, String hierarchy) throws SAXException {
        if (course != null) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", course.getId());
            attrs.addCDATAAttribute("name", course.getName());
            attrs.addCDATAAttribute("path", StringUtils.join((Object[])new String[]{hierarchy, "/"}));
            XMLUtils.startElement((ContentHandler)handler, (String)"course", (Attributes)attrs);
            XMLUtils.createElement((ContentHandler)handler, (String)"ordre", (String)String.valueOf(this._order));
            this._saxProgram(handler, program);
            this._saxSubProgram(handler, subprogram);
            this._saxYear(handler, containerYear);
            this._saxParentCourse(handler, parentCourse);
            this._saxCourseList(handler, list, listPosition);
            boolean aDesFils = course.hasCourseLists();
            XMLUtils.createElement((ContentHandler)handler, (String)"aDesFils", (String)(aDesFils ? "X" : ""));
            this._saxPartage(handler, course.getParentCourseLists().size());
            Container etape = this._getEtapePorteuse(course, hierarchy);
            String porte = this._getPorte(etape, containerYear);
            XMLUtils.createElement((ContentHandler)handler, (String)"porte", (String)porte);
            XMLUtils.createElement((ContentHandler)handler, (String)"niveau", (String)("niv" + level));
            XMLUtils.createElement((ContentHandler)handler, (String)"creationDate", (String)DateUtils.zonedDateTimeToString((ZonedDateTime)course.getCreationDate()));
            XMLUtils.createElement((ContentHandler)handler, (String)"codeApogee", (String)((String)course.getValue("elpCode", false, (Object)"")));
            XMLUtils.createElement((ContentHandler)handler, (String)"nature", (String)this._refTableHelper.getItemCode(course.getCourseType()));
            XMLUtils.createElement((ContentHandler)handler, (String)"libelleCourt", (String)((String)course.getValue("shortLabel", false, (Object)"")));
            XMLUtils.createElement((ContentHandler)handler, (String)"libelle", (String)course.getTitle());
            XMLUtils.createElement((ContentHandler)handler, (String)"elpCode", (String)course.getDisplayCode());
            this._reportHelper.saxContentAttribute(handler, (ModifiableDefaultContent)course, "campus", "campus");
            XMLUtils.createElement((ContentHandler)handler, (String)"ects", (String)String.valueOf(course.getEcts()));
            String teachingActivity = this._refTableHelper.getItemCode(course.getTeachingActivity());
            String stage = teachingActivity.equals("SA") ? "X" : "";
            XMLUtils.createElement((ContentHandler)handler, (String)"stage", (String)stage);
            Content period = Optional.of("period").map(arg_0 -> ((Course)course).getValue(arg_0)).flatMap(ContentValue::getContentIfExists).orElse(null);
            if (period != null) {
                try {
                    String periodCode = Optional.of("code").map(arg_0 -> ((Content)period).getValue(arg_0)).orElse("");
                    String periodTypeCode = Optional.ofNullable((ContentValue)period.getValue("type")).flatMap(ContentValue::getContentIfExists).map(c -> (String)c.getValue("code")).orElse("");
                    XMLUtils.createElement((ContentHandler)handler, (String)"periode", (String)("s10".equals(periodCode) ? "s0" : periodCode));
                    XMLUtils.createElement((ContentHandler)handler, (String)"periodeType", (String)periodTypeCode);
                }
                catch (UnknownAmetysObjectException e) {
                    this.getLogger().error("Impossible de retrouver la p\u00e9riode : {}", (Object)period, (Object)e);
                }
            }
            this._saxOrgUnit(handler, this._getOrgUnit(course, hierarchy));
            long codeAnu = (Long)course.getValue("CodeAnu", false, (Object)0L);
            XMLUtils.createElement((ContentHandler)handler, (String)"CodeAnu", (String)(codeAnu > 0L ? String.valueOf(codeAnu) : ""));
            XMLUtils.createElement((ContentHandler)handler, (String)"calculCharges", (String)(aDesFils ? "" : "X"));
            String disciplineEnseignement = Optional.of("disciplineEnseignement").map(arg_0 -> ((Course)course).getValue(arg_0)).flatMap(ContentValue::getContentIfExists).map(OdfReferenceTableEntry::new).map(entry -> {
                String code = entry.getCode();
                return (String)(StringUtils.isNotEmpty((CharSequence)code) ? "[" + code + "] " : "") + entry.getLabel(course.getLanguage());
            }).orElse("");
            XMLUtils.createElement((ContentHandler)handler, (String)"discipline", (String)disciplineEnseignement);
            if (lastLevel) {
                this._saxStepHolder(handler, etape);
                XMLUtils.startElement((ContentHandler)handler, (String)"courseParts");
                for (CoursePart coursePart : course.getCourseParts()) {
                    AttributesImpl attr = new AttributesImpl();
                    attr.addCDATAAttribute("id", coursePart.getId());
                    XMLUtils.createElement((ContentHandler)handler, (String)"coursePart", (Attributes)attr);
                }
                XMLUtils.endElement((ContentHandler)handler, (String)"courseParts");
            }
            XMLUtils.endElement((ContentHandler)handler, (String)"course");
            ++this._order;
        }
    }

    private void _saxProgram(ContentHandler handler, Program program) throws SAXException {
        if (program != null) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", program.getId());
            attrs.addCDATAAttribute("name", program.getName());
            XMLUtils.startElement((ContentHandler)handler, (String)"program", (Attributes)attrs);
            XMLUtils.createElement((ContentHandler)handler, (String)"title", (String)program.getTitle());
            XMLUtils.createElement((ContentHandler)handler, (String)"code", (String)program.getDisplayCode());
            String orgUnit = Arrays.stream((ContentValue[])program.getValue("orgUnit")).map(ContentValue::getContentIfExists).flatMap(Optional::stream).map(OrgUnit.class::cast).map(ou -> ou.getTitle() + " (" + ou.getDisplayCode() + ")").collect(Collectors.joining(", "));
            XMLUtils.createElement((ContentHandler)handler, (String)"orgUnits", (String)orgUnit);
            XMLUtils.endElement((ContentHandler)handler, (String)"program");
        }
    }

    private void _saxSubProgram(ContentHandler handler, SubProgram subprogram) throws SAXException {
        if (subprogram != null) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", subprogram.getId());
            attrs.addCDATAAttribute("name", subprogram.getName());
            XMLUtils.startElement((ContentHandler)handler, (String)"subProgram", (Attributes)attrs);
            XMLUtils.createElement((ContentHandler)handler, (String)"title", (String)subprogram.getTitle());
            XMLUtils.createElement((ContentHandler)handler, (String)"code", (String)subprogram.getDisplayCode());
            XMLUtils.endElement((ContentHandler)handler, (String)"subProgram");
        }
    }

    private void _saxYear(ContentHandler handler, Container container) throws SAXException {
        if (container != null) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", container.getId());
            attrs.addCDATAAttribute("name", container.getName());
            XMLUtils.startElement((ContentHandler)handler, (String)"year", (Attributes)attrs);
            XMLUtils.createElement((ContentHandler)handler, (String)"title", (String)container.getTitle());
            XMLUtils.createElement((ContentHandler)handler, (String)"code", (String)container.getDisplayCode());
            XMLUtils.createElement((ContentHandler)handler, (String)"COD_ETP", (String)((String)container.getValue("etpCode", false, (Object)"")));
            XMLUtils.createElement((ContentHandler)handler, (String)"COD_VRS_ETP", (String)((String)container.getValue("vrsEtpCode", false, (Object)"")));
            XMLUtils.createElement((ContentHandler)handler, (String)"nbStudents", (String)String.valueOf(container.getValue("numberOfStudentsEstimated", false, (Object)0)));
            XMLUtils.endElement((ContentHandler)handler, (String)"year");
        }
    }

    private void _saxParentCourse(ContentHandler handler, Course parentCourse) throws SAXException {
        if (parentCourse != null) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", parentCourse.getId());
            attrs.addCDATAAttribute("name", parentCourse.getName());
            XMLUtils.startElement((ContentHandler)handler, (String)"parentCourse", (Attributes)attrs);
            XMLUtils.createElement((ContentHandler)handler, (String)"codeELPPere", (String)parentCourse.getDisplayCode());
            XMLUtils.endElement((ContentHandler)handler, (String)"parentCourse");
        }
    }

    private void _saxOrgUnit(ContentHandler handler, OrgUnit orgUnit) throws SAXException {
        if (orgUnit != null) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", orgUnit.getId());
            XMLUtils.startElement((ContentHandler)handler, (String)"orgUnit", (Attributes)attrs);
            String codeComposante = Optional.ofNullable(orgUnit).map(o -> (String)o.getValue("codCmp")).orElse("");
            XMLUtils.createElement((ContentHandler)handler, (String)"codeComposante", (String)codeComposante);
            String codeCIP = Optional.ofNullable(orgUnit).map(o -> (String)o.getValue("codCipApogee")).orElse("");
            XMLUtils.createElement((ContentHandler)handler, (String)"codeCIP", (String)codeCIP);
            XMLUtils.endElement((ContentHandler)handler, (String)"orgUnit");
        }
    }

    private String _getPorte(Container etape, Container containerYear) {
        String etpCode;
        String porte = "";
        if (etape != null && containerYear != null && StringUtils.isNotEmpty((CharSequence)(etpCode = (String)containerYear.getValue("etpCode", false, (Object)"")))) {
            porte = etpCode.equals(etape.getValue("etpCode", false, (Object)"")) ? "X" : "";
        }
        return porte;
    }

    private OrgUnit _getOrgUnit(Course course, String hierarchy) {
        OrgUnit orgUnit = null;
        List courseOrgUnits = course.getOrgUnits();
        if (!courseOrgUnits.isEmpty()) {
            block4: {
                try {
                    orgUnit = (OrgUnit)this._resolver.resolveById((String)courseOrgUnits.get(0));
                }
                catch (UnknownAmetysObjectException e) {
                    if (!this.getLogger().isInfoEnabled()) break block4;
                    this.getLogger().info("La composante r\u00e9f\u00e9renc\u00e9e par l'\u00e9l\u00e9ment p\u00e9dagogique {} ({}) n'a pas \u00e9t\u00e9 trouv\u00e9e.", (Object)this._pilotageHelper.getDisplayablePath(hierarchy), (Object)course.getCode());
                }
            }
            if (courseOrgUnits.size() > 1 && this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("L'\u00e9l\u00e9ment p\u00e9dagogique {} ({}) r\u00e9f\u00e9rence plus d'une composante.", (Object)this._pilotageHelper.getDisplayablePath(hierarchy), (Object)course.getCode());
            }
        }
        return orgUnit;
    }

    private Container _getEtapePorteuse(Course course, String hierarchy) {
        Pair<PilotageHelper.StepHolderStatus, Container> stepHolder = this._pilotageHelper.getStepHolder((ProgramItem)course);
        switch ((PilotageHelper.StepHolderStatus)((Object)stepHolder.getKey())) {
            case NO_YEAR: {
                if (!this.getLogger().isWarnEnabled()) break;
                this.getLogger().warn("Impossible de trouver une nature de conteneur 'annee' pour l'\u00e9l\u00e9ment p\u00e9dagogique {} ({}).", (Object)this._pilotageHelper.getDisplayablePath(hierarchy), (Object)course.getCode());
                break;
            }
            case NONE: {
                if (!this.getLogger().isInfoEnabled()) break;
                this.getLogger().info("L'\u00e9l\u00e9ment p\u00e9dagogique {} ({}) n'est rattach\u00e9 \u00e0 aucune ann\u00e9e.", (Object)this._pilotageHelper.getDisplayablePath(hierarchy), (Object)course.getCode());
                break;
            }
            case MULTIPLE: {
                if (!this.getLogger().isInfoEnabled()) break;
                this.getLogger().info("Impossible de d\u00e9finir une ann\u00e9e porteuse unique sur l'\u00e9l\u00e9ment p\u00e9dagogique {} ({}).", (Object)this._pilotageHelper.getDisplayablePath(hierarchy), (Object)course.getCode());
                break;
            }
            case WRONG_YEAR: {
                if (!this.getLogger().isInfoEnabled()) break;
                this.getLogger().info("L'ann\u00e9e porteuse {} n'est pas dans l'arborescence de l'\u00e9l\u00e9ment p\u00e9dagogique {} ({})", new Object[]{((Container)stepHolder.getValue()).getTitle(), this._pilotageHelper.getDisplayablePath(hierarchy), course.getCode()});
                break;
            }
        }
        return (Container)stepHolder.getValue();
    }

    private void _saxCourseList(ContentHandler handler, CourseList list, Integer position) throws SAXException {
        if (list != null) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", list.getId());
            attrs.addCDATAAttribute("name", list.getName());
            attrs.addCDATAAttribute("displayName", "Lst" + position);
            CourseList.ChoiceType typeList = list.getType();
            if (typeList != null) {
                switch (typeList) {
                    case CHOICE: {
                        attrs.addCDATAAttribute("type", "X");
                        attrs.addCDATAAttribute("minmax", this._reportHelper.formatNumberToSax(list.getMinNumberOfCourses()));
                        break;
                    }
                    case MANDATORY: {
                        attrs.addCDATAAttribute("type", "O");
                        break;
                    }
                    case OPTIONAL: {
                        attrs.addCDATAAttribute("type", "F");
                        break;
                    }
                }
            }
            XMLUtils.createElement((ContentHandler)handler, (String)"courseList", (Attributes)attrs);
        }
    }

    private void _saxPartage(ContentHandler handler, long nbParents) throws SAXException {
        if (nbParents > 1L) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("occurrences", this._reportHelper.formatNumberToSax(nbParents));
            XMLUtils.createElement((ContentHandler)handler, (String)"partage", (Attributes)attrs);
        }
    }

    private void _saxStepHolder(ContentHandler handler, Container etape) throws SAXException {
        if (etape != null) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", etape.getId());
            XMLUtils.startElement((ContentHandler)handler, (String)"stepHolder", (Attributes)attrs);
            XMLUtils.createElement((ContentHandler)handler, (String)"code", (String)etape.getDisplayCode());
            XMLUtils.createElement((ContentHandler)handler, (String)"etpCode", (String)((String)etape.getValue("etpCode", false, (Object)"")));
            XMLUtils.createElement((ContentHandler)handler, (String)"vrsEtpCode", (String)((String)etape.getValue("vrsEtpCode", false, (Object)"")));
            XMLUtils.createElement((ContentHandler)handler, (String)"title", (String)etape.getTitle());
            XMLUtils.endElement((ContentHandler)handler, (String)"stepHolder");
        }
    }

    private Map<Program, Object> _getStructure(OrgUnit rootOrgUnit, String lang, String catalog) {
        TreeMap<Content, Map<ProgramItem, Object>> programTree = new TreeMap<Content, Map<ProgramItem, Object>>(ReportHelper.CONTENT_TITLE_COMPARATOR);
        if (rootOrgUnit.getParentOrgUnit() == null || rootOrgUnit.getParentOrgUnit().getParentOrgUnit() == null) {
            List programs = this._odfHelper.getProgramsFromOrgUnit(rootOrgUnit, catalog, lang);
            for (Program program : programs) {
                Map<ProgramItem, Object> courses = this._reportHelper.getCoursesFromContent((ProgramItem)program);
                programTree.put((Content)program, courses);
            }
        }
        return programTree;
    }

    private void _writeLines(ContentHandler handler, CostComputationData costData) throws SAXException {
        XMLUtils.startElement((ContentHandler)handler, (String)"courseParts");
        for (String contentId : costData.keySet()) {
            AttributesImpl attrs;
            ProgramItemData coursePartData = (ProgramItemData)costData.get(contentId);
            if (!coursePartData.isCoursePart()) continue;
            CoursePart coursePart = (CoursePart)this._resolver.resolveById(contentId);
            AttributesImpl attr = new AttributesImpl();
            attr.addCDATAAttribute("id", contentId);
            attr.addCDATAAttribute("name", coursePart.getName());
            XMLUtils.startElement((ContentHandler)handler, (String)"coursePart", (Attributes)attr);
            Map<String, String> calculatedCoursePart = this.getValues(coursePart, coursePartData);
            for (String string : calculatedCoursePart.keySet()) {
                XMLUtils.createElement((ContentHandler)handler, (String)string, (String)calculatedCoursePart.get(string));
            }
            for (Map.Entry entry : coursePartData.getEqTD().getProratedEqTD().entrySet()) {
                attrs = new AttributesImpl();
                attrs.addCDATAAttribute("path", (String)entry.getKey());
                XMLUtils.createElement((ContentHandler)handler, (String)"proratedEqTD", (Attributes)attrs, (String)String.valueOf(entry.getValue()));
            }
            for (Map.Entry entry : coursePartData.getEffectives().getLocalEffectiveByPath().entrySet()) {
                attrs = new AttributesImpl();
                attrs.addCDATAAttribute("path", (String)entry.getKey());
                XMLUtils.createElement((ContentHandler)handler, (String)"effectif", (Attributes)attrs, (String)String.valueOf(entry.getValue()));
            }
            for (Map.Entry entry : coursePartData.getEqTD().getLocalEqTD().entrySet()) {
                attrs = new AttributesImpl();
                attrs.addCDATAAttribute("path", (String)entry.getKey());
                XMLUtils.createElement((ContentHandler)handler, (String)"localEqTD", (Attributes)attrs, (String)String.valueOf(entry.getValue()));
            }
            XMLUtils.endElement((ContentHandler)handler, (String)"coursePart");
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"courseParts");
    }

    private void _writeColumns(ContentHandler handler, CostComputationData costData) throws SAXException {
        XMLUtils.startElement((ContentHandler)handler, (String)"columns");
        for (Container yearToDisplay : this._getYearsToDisplay(costData)) {
            this._writeColumn(handler, yearToDisplay);
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"columns");
    }

    private void _writeColumn(ContentHandler handler, Container year) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", year.getId());
        attrs.addCDATAAttribute("name", year.getName());
        XMLUtils.createElement((ContentHandler)handler, (String)"column", (Attributes)attrs, (String)this._getDisplayCode(year));
    }

    private Set<Container> _getYearsToDisplay(CostComputationData costData) {
        return costData.entrySet().stream().filter(entry -> ((ProgramItemData)entry.getValue()).isCoursePart()).map(Map.Entry::getKey).map(arg_0 -> ((AmetysObjectResolver)this._resolver).resolveById(arg_0)).map(CoursePart::getCourses).flatMap(Collection::stream).map(this._pilotageHelper::getSteps).flatMap(Collection::stream).collect(Collectors.toCollection(() -> new LinkedHashSet()));
    }

    private String _getDisplayCode(Container container) {
        return this._getValueOrNull((Content)container, "anneePorteuse").or(() -> this._getValueOrNull((Content)container, "etpCode").map(code -> code + this._getValueOrNull((Content)container, "vrsEtpCode").map(c -> "-" + c).orElse(""))).or(() -> this._getValueOrNull((Content)container, "code")).orElse("");
    }

    private Optional<String> _getValueOrNull(Content content, String attributeName) {
        return Optional.of(content).map(c -> (String)c.getValue(attributeName)).filter(StringUtils::isNotEmpty);
    }

    private Map<String, String> getValues(CoursePart coursePart, ProgramItemData programItemData) {
        EqTD eqTD;
        Groups groups;
        NormDetails normDetails;
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("titre", coursePart.getTitle());
        values.put("code", coursePart.getCode());
        values.put("nature", this._refTableHelper.getItemCode(coursePart.getNature()));
        values.put("volumeHoraire", ReportHelper.FORMAT_2_DIGITS.format(coursePart.getNumberOfHours()));
        Course courseHolder = coursePart.getCourseHolder();
        if (courseHolder == null) {
            this.getLogger().warn("Les heures d'enseignement '{}' ({}) n'ont plus d'ELP porteur.", (Object)coursePart.getTitle(), (Object)coursePart.getCode());
        } else {
            values.put("elpPorteur", courseHolder.getDisplayCode());
        }
        Effectives effectives = programItemData.getEffectives();
        if (effectives != null) {
            values.put("effectifCalcule", effectives.getComputedEffective().map(ReportHelper.FORMAT_2_DIGITS::format).orElse(""));
            values.put("effectifPrevisionnel", effectives.getEstimatedEffective().map(ReportHelper.FORMAT_2_DIGITS::format).orElse(""));
        }
        if ((normDetails = programItemData.getNormDetails()) != null) {
            values.put("effectifMax", Optional.of(normDetails).map(NormDetails::getEffectiveMax).map(ReportHelper.FORMAT_2_DIGITS::format).orElse(""));
            values.put("effectifMinSup", Optional.of(normDetails).map(NormDetails::getEffectiveMinSup).map(ReportHelper.FORMAT_2_DIGITS::format).orElse(""));
            values.put("norme", normDetails.getNormLabel());
        }
        if ((groups = programItemData.getGroups()) != null) {
            values.put("groupesCalcules", ReportHelper.FORMAT_2_DIGITS.format(groups.getComputedGroups()));
            Long groupsToOpen = groups.getGroupsToOpen();
            if (groupsToOpen != null) {
                values.put("groupesAOuvrir", ReportHelper.FORMAT_2_DIGITS.format(groupsToOpen));
            }
        }
        if ((eqTD = programItemData.getEqTD()) != null) {
            values.put("eqTDTotal", ReportHelper.FORMAT_2_DIGITS.format(eqTD.getGlobalEqTD()));
        }
        values.values().removeIf(Objects::isNull);
        return values;
    }
}

