/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.rule.export.csv;

import org.ametys.core.util.I18nUtils;
import org.ametys.odf.catalog.CatalogsManager;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.plugins.odfpilotage.rule.export.AbstractSetContentDispositionHeaderAction;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class SetModifiedRulesHeaderCSVAction
extends AbstractSetContentDispositionHeaderAction
implements Serviceable {
    protected CatalogsManager _catalogsManager;
    protected AmetysObjectResolver _resolver;
    protected I18nUtils _i18nUtils;

    public void service(ServiceManager manager) throws ServiceException {
        this._catalogsManager = (CatalogsManager)manager.lookup(CatalogsManager.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
    }

    @Override
    protected String buildFilename(Request request, Parameters parameters) throws Exception {
        String lang = (String)Config.getInstance().getValue("odf.programs.lang");
        String type = parameters.getParameter("type");
        String catalog = parameters.getParameter("catalog");
        String orgUnitId = parameters.getParameter("orgUnit");
        OrgUnit orgUnit = StringUtils.isNotBlank((CharSequence)orgUnitId) ? (OrgUnit)this._resolver.resolveById(orgUnitId) : null;
        StringBuilder filename = new StringBuilder();
        switch (type) {
            case "derogation": {
                filename.append(this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_DASHBOARD_EXPORT_CSV_DEROGATIONS_FILE_TITLE"), lang));
                break;
            }
            case "complementary": {
                filename.append(this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_DASHBOARD_EXPORT_CSV_COMPLEMENTARY_FILE_TITLE"), lang));
                break;
            }
            default: {
                filename.append(this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_DASHBOARD_EXPORT_CSV_ADDITIONAL_FILE_TITLE"), lang));
            }
        }
        filename.append(" - ");
        filename.append(this._catalogsManager.getCatalog(catalog).getTitle());
        if (orgUnit != null) {
            filename.append(" - ");
            filename.append(orgUnit.getTitle());
        }
        filename.append(".csv");
        return filename.toString();
    }
}

