<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                exclude-result-prefixes="ametys">
    
    <xsl:import href="view://stylesheets/content/common.xsl"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-content-name">thematic</xsl:variable>
    
    <!-- +
         | HEAD
         + -->

    <!-- Used in common.xsl -->
    <xsl:template name="common-content-head-title">
        <xsl:call-template name="common-content-head-title-content"/>
    </xsl:template> 

    <!-- +
         | BODY
         + -->
    <!-- Used in common.xsl -->
    <xsl:template name="common-content-body-title">
        <xsl:call-template name="common-content-body-title-content"/>
    </xsl:template>
    
    <xsl:template name="common-content-head-css">
        <link rel="stylesheet" href="{ametys:uriPrefix()}/plugins/odf-pilotage/resources/css/content/Thematic.css"/>
    </xsl:template>
    
    <xsl:template name="common-content-body-title-content">
        <h1>
            <span class="content-title"><xsl:value-of select="metadata/code"/> - <xsl:value-of select="metadata/title"/></span>
        </h1>
    </xsl:template>
    
    <xsl:template match="*" mode="archived">
        <xsl:choose>
            <xsl:when test="archived = 'true'"><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_ARCHIVED" i18n:catalogue="plugin.odf-pilotage"/></xsl:when>
            <xsl:otherwise><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_ONLINE" i18n:catalogue="plugin.odf-pilotage"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>
