<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:su="org.ametys.core.util.StringUtils"
                xmlns:exsl="http://exslt.org/common"
                xmlns:odf="org.ametys.plugins.odfweb.xslt.OdfXSLTHelper"
                exclude-result-prefixes="i18n exsl su odf">
    
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/report/params/maquette.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/utils.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/xls.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/report/maquette/legende2xls.xsl"/>
    
    <xsl:variable name="nbColumnsBefore" select="6"/>
    <xsl:variable name="nbColumnsAfter" select="1"/>
    <xsl:variable name="nbColumns" select="$nbColumnsBefore + $nbNatureEnseignement + $nbColumnsAfter"/>
    <xsl:param name="titleColumnPosition" select="3"/>
    
    <xsl:template name="css-styles">
        <xsl:call-template name="css-styles-maquette"/>
    </xsl:template>
    
    <xsl:template name="css-styles-maquette">
        .h1, .h2, .h3
        {
            text-align: center;
            font-weight: bold;
        }
        
        .h1, .h2
        {
            font-size: 15pt;
        }
        
        .h3
        {
            font-size: 13.5pt;
        }
        
        .h4
        {
            font-size: 12pt;
            font-weight: bold;
            color: darkblue;
        }
        
        table
        {
            font-size: 7.5pt;
            width: 100%;
            padding: 0px;
            margin: 0px;
            border-spacing: 0;
            border-collapse: collapse;
        }
        
        thead tr td
        {
            font-weight: bold;
            text-align: center;
            background-color: darkblue;
            color: white;
            vertical-align: middle;
        }
        
        td 
        { 
            padding: 0px;
            margin: 0px;
            border-bottom:0.5pt solid  #333333;
        }
        
        .border
        { 
            border-left:0.5pt solid  #333333;
            text-align:center;
        }
        
        .codeEtapePorteuse
        { 
            border-left:0.5pt solid  #333333;
            text-align:left;
        }
        
        .codeAmetys
        {
            color: #777777;
        }
        
        .choisirElement td
        {
            color: darkblue;
        }
        
        .etapePorteuse
        {
            background-color: #DDDDDD;
        }
        
        .legend-title
        {
            color: #000080;
            font-weight: bold;
            padding-bottom: 3.0pt;
            font-size: 8.0pt;
        }
        
        .legend td
        {
            border-bottom: none;
            font-size: 8.0pt;
        }
        
        .legend td.etapePorteuse
        {
            padding-left: 3mm;
        }
    </xsl:template>
    
    <xsl:template name="table-body">
        <xsl:apply-templates select="program" />
        <xsl:call-template name="legende"/>
    </xsl:template>
    
    <xsl:template match="program">
        <xsl:variable name="suffix">
            <xsl:apply-templates select="." mode="suffix"/>
        </xsl:variable>
        <tr>
            <td colspan="{$nbColumns}" class="h1{$suffix}">
                <xsl:apply-templates select="." mode="title"/>
            </td>
        </tr>
        
        <xsl:apply-templates select="subProgram|container|courseList"/>
    </xsl:template>
    
    <xsl:template match="subProgram">
        <xsl:variable name="suffix">
            <xsl:apply-templates select="." mode="suffix"/>
        </xsl:variable>
        <tr>
            <td colspan="{$nbColumns}" class="h2{$suffix}">
                <xsl:apply-templates select="." mode="title"/>
            </td>
        </tr>
        
        <xsl:apply-templates select="subProgram|container|courseList"/>
    </xsl:template>
    
    <xsl:template match="container[nature/code = 'annee']">
        <xsl:variable name="suffix">
            <xsl:apply-templates select="." mode="suffix"/>
        </xsl:variable>
        
        <tr>
            <td colspan="{$nbColumns}" class="h3{$suffix}">
                <xsl:apply-templates select="." mode="title"/>
            </td>
        </tr>
        
        <xsl:apply-templates select="subProgram|container|courseList">
            <xsl:with-param name="COD_ETP_YEAR" select="contentId"/>
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template match="container">
        <xsl:param name="COD_ETP_YEAR" />
        <xsl:variable name="suffix">
            <xsl:apply-templates select="." mode="suffix"/>
        </xsl:variable>
        
        <tr>
            <td colspan="{$nbColumns}" class="h4{$suffix}">
                <xsl:apply-templates select="." mode="title"/>
            </td>
        </tr>
        
        <xsl:apply-templates select="subProgram|container|courseList">
            <xsl:with-param name="COD_ETP_YEAR" select="$COD_ETP_YEAR"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="courseList">
        <xsl:param name="COD_ETP_YEAR" />
    
        <xsl:apply-templates select="." mode="child">
            <xsl:with-param name="indent" select="0"/>
            <xsl:with-param name="COD_ETP_YEAR" select="$COD_ETP_YEAR"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template name="table-head" >
        <tr>
            <xsl:call-template name="before-course-parts"/>
            <xsl:for-each select="exsl:node-set($naturesEnseignementByCategory)/category">
                <td style="width: 15mm;"><xsl:value-of select="su:sanitizeXlsHtml(@code)"/></td>
            </xsl:for-each>
            <xsl:call-template name="after-course-parts"/>
        </tr>
    </xsl:template>
    
     <xsl:template name="before-course-parts">
        <td style="width: 20mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_CODE_AMETYS"/></td>
        <td style="width: 100mm;"/>
        <td style="width: 15mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_NATURE"/></td>
        <td style="width: 10mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_ECTS"/></td>
        <td style="width: 10mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_PARTAGE_ABREV"/></td>
        <td style="width: 10mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_OCCURRENCE_ABREV"/></td>
    </xsl:template>
    
    <xsl:template name="after-course-parts">
       <td style="width: 50mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_ETAPE_PORTEUSE"/></td>
    </xsl:template>
    
    <xsl:template match="courseList" mode="child">
        <xsl:param name="indent" />
        <xsl:param name="COD_ETP_YEAR" />
        
        <xsl:apply-templates select="." mode="courselist-header">
            <xsl:with-param name="indent" select="$indent"/>
        </xsl:apply-templates>
        
        <xsl:apply-templates select="course">
            <xsl:with-param name="indent" select="$indent"/>
            <xsl:with-param name="COD_ETP_YEAR" select="$COD_ETP_YEAR"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="courseList[choiceType/@value = 'OPTIONAL']" mode="courselist-header">
        <xsl:param name="indent"/>
        
        <xsl:variable name="suffix">
            <xsl:apply-templates select="." mode="suffix"/>
        </xsl:variable>
        
        <tr class="choisirElement{$suffix}">
            <td colspan="{$titleColumnPosition - 1}"/>
            <td colspan="{$nbColumns - $titleColumnPosition + 1}">
                <xsl:call-template name="recursive-print">
                    <xsl:with-param name="times" select="$indent - 1" />
                </xsl:call-template>
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_ENSEIGNEMENTS_FACULTATIFS"/>
            </td>
        </tr>
    </xsl:template>
    
    <xsl:template match="courseList[choiceType/@value = 'CHOICE']" mode="courselist-header">
        <xsl:param name="indent"/>
        
        <xsl:variable name="suffix">
            <xsl:apply-templates select="." mode="suffix"/>
        </xsl:variable>
        
        <tr class="choisirElement{$suffix}">
            <td colspan="{$titleColumnPosition - 1}"/>
            <td colspan="{$nbColumns - $titleColumnPosition + 1}">
                <xsl:call-template name="recursive-print">
                    <xsl:with-param name="times" select="$indent - 1" />
                </xsl:call-template>
                    
                <xsl:variable name="isPlural"><xsl:if test="current() > 1">S</xsl:if></xsl:variable>
                <i18n:translate>
                    <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MAQUETTE_CHOICE_ELEMENT{$isPlural}"/>
                    <i18n:param><xsl:value-of select="min" /></i18n:param>
                </i18n:translate>
            </td>
        </tr>
    </xsl:template>
    
    <xsl:template match="courseList" mode="courselist-header"/>
    
    <xsl:template match="course">
        <xsl:param name="indent" />
        <xsl:param name="COD_ETP_YEAR" />
        
        <xsl:variable name="suffix">
            <xsl:apply-templates select="." mode="suffix"/>
        </xsl:variable>
        
        <tr>
            <xsl:if test="etapePorteuse/title != '' and not($COD_ETP_YEAR = etapePorteuse/@id)">
                <xsl:attribute name="class">etapePorteuse</xsl:attribute>
            </xsl:if>
            
            <xsl:apply-templates select="." mode="cell-codeAmetys">
                <xsl:with-param name="suffix" select="$suffix"/>
            </xsl:apply-templates>
            
            <xsl:apply-templates select="." mode="cell-label">
                <xsl:with-param name="suffix" select="$suffix"/>
                <xsl:with-param name="indent" select="$indent"/>
            </xsl:apply-templates>
            
            <xsl:apply-templates select="." mode="cell-nature">
                <xsl:with-param name="suffix" select="$suffix"/>
            </xsl:apply-templates>
            
            <xsl:apply-templates select="." mode="cell-ects">
                <xsl:with-param name="suffix" select="$suffix"/>
            </xsl:apply-templates>
            
            <xsl:apply-templates select="." mode="cell-shared">
                <xsl:with-param name="suffix" select="$suffix"/>
            </xsl:apply-templates>
            
            <xsl:apply-templates select="." mode="cell-courseParts">
                <xsl:with-param name="suffix" select="$suffix"/>
            </xsl:apply-templates>
            
            <xsl:apply-templates select="." mode="cell-etapePorteuse">
                <xsl:with-param name="suffix" select="$suffix"/>
            </xsl:apply-templates>
        </tr>
        
        <xsl:call-template name="coursesChildren">
            <xsl:with-param name="indent" select="$indent"/>
            <xsl:with-param name="COD_ETP_YEAR" select="$COD_ETP_YEAR"/>
        </xsl:call-template>
    </xsl:template>
    
     <xsl:template match="course" mode="cell-codeAmetys">
        <xsl:param name="suffix"/>
       
        <td class="codeAmetys{$suffix}">
            <xsl:choose>
                <xsl:when test="displayCode != ''"><xsl:value-of select="su:sanitizeXlsHtml(displayCode)"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="su:sanitizeXlsHtml(code)" /></xsl:otherwise>
            </xsl:choose>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-codeApogee">
        <xsl:param name="suffix"/>
       
        <td class="course{$suffix}">
            <xsl:value-of select="su:sanitizeXlsHtml(elpCode)" />
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-label">
        <xsl:param name="suffix"/>
        <xsl:param name="indent"/>
        
        <td class="course{$suffix}">
            <xsl:if test="$indent = 0"><xsl:attribute name="style">font-size:9pt;</xsl:attribute></xsl:if>
            <xsl:call-template name="recursive-print">
                <xsl:with-param name="times" select="$indent" />
            </xsl:call-template>
            <xsl:call-template name="courseLabel"/>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-nature">
        <xsl:param name="suffix"/>
        
        <xsl:variable name="nature">
            <xsl:call-template name="displayCodeOrShortLabel">
                <xsl:with-param name="contentId" select="courseType/@id"/>
            </xsl:call-template>
        </xsl:variable>
        
        <td class="border{$suffix}">
            <xsl:value-of select="su:sanitizeXlsHtml($nature)" />
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-ects">
        <xsl:param name="suffix"/>
        
        <td class="border{$suffix}">
            <xsl:call-template name="display-double">
                <xsl:with-param name="value" select="odf:getEcts(@id, @path)" />
            </xsl:call-template>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-shared">
        <xsl:param name="suffix"/>
        
        <xsl:variable name="occurences" select="count(parentCourseLists)"/>
        <td class="border{$suffix}">
            <xsl:if test="$occurences > 1">X</xsl:if>
        </td>
        <td class="border{$suffix}">
            <xsl:if test="$occurences > 1"><xsl:value-of select="$occurences"/></xsl:if>
        </td>
    </xsl:template>
    
    <xsl:template match="course"  mode="cell-courseParts">
        <xsl:param name="suffix"/>
        
        <xsl:variable name="currentCourse" select="."/>
        
        <xsl:for-each select="exsl:node-set($naturesEnseignementByCategory)/category">
            <td class="border{$suffix}">
                <xsl:for-each select="item">
                    <xsl:variable name="courseParts" select="$currentCourse/courseParts[nature/@id = current()/@id]"/>
                    <xsl:if test="count($courseParts) > 0">
                        <xsl:call-template name="display-double">
                            <xsl:with-param name="value"><xsl:value-of select="sum($courseParts/nbHours)"/></xsl:with-param>
                        </xsl:call-template>
                        <xsl:if test="@code != ../@code">
                            <xsl:text> </xsl:text>(<xsl:value-of select="@code"/>)
                        </xsl:if>
                        <xsl:if test="position() != last()">
                            <br/>
                        </xsl:if>
                    </xsl:if>
                </xsl:for-each>
            </td>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-etapePorteuse">
        <xsl:param name="suffix"/>
        
        <td class="codeEtapePorteuse{$suffix}">
            <xsl:if test="etapePorteuse/title != ''">
                <xsl:apply-templates select="etapePorteuse" mode="title"/>
            </xsl:if>
        </td>
    </xsl:template>
    
    <xsl:template name="coursesChildren">
        <xsl:param name="indent" />
        <xsl:param name="COD_ETP_YEAR" />
        <xsl:apply-templates select="courseList" mode="child">
            <xsl:with-param name="indent" select="$indent + 1"/>
            <xsl:with-param name="COD_ETP_YEAR" select="$COD_ETP_YEAR"/>
        </xsl:apply-templates>
    </xsl:template>
    
   <xsl:template match="program|subProgram|container|etapePorteuse" mode="title">
        <xsl:value-of select="su:sanitizeXlsHtml(title)" />
        
        <xsl:apply-templates select="." mode="title-code-suffix"/>
    </xsl:template>
    
    <xsl:template match="program" mode="title-code-suffix">
        <xsl:if test="displayCode != ''">
            <text> - </text>
            <xsl:value-of select="displayCode" />
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="container[nature/code = 'annee']|etapePorteuse" mode="title-code-suffix">
        <xsl:if test="displayCode != ''">
            <text> (</text>
            <xsl:value-of select="displayCode" />
            <text>)</text>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="*" mode="title-code-suffix"/>
    
    <xsl:template match="program|subProgram|container|courseList|course" mode="suffix"/>
    
    <xsl:template name="courseLabel">
        <xsl:if test="shortLabel != ''">
            <xsl:value-of select="su:sanitizeXlsHtml(shortLabel)"/><xsl:text> </xsl:text>
        </xsl:if>
        <xsl:value-of select="su:sanitizeXlsHtml(title)" />
    </xsl:template>
</xsl:stylesheet>
