/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.catalog;

import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.cms.repository.Content;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.catalog.AbstractProgramItemAttributeCopyUpdater;
import org.ametys.odf.program.Container;
import org.ametys.plugins.odfpilotage.helper.MCCWorkflowHelper;

/**
 * The catalog copy updater to remove the MCC data
 */
public class MCCCopyUpdater extends AbstractProgramItemAttributeCopyUpdater implements Serviceable
{
    /** The ODF helper */
    protected ODFHelper _odfHelper;
    
    /** The MCC workflow helper */
    protected MCCWorkflowHelper _mccWorkflowHelper;

    public void service(ServiceManager manager) throws ServiceException
    {
        _odfHelper = (ODFHelper) manager.lookup(ODFHelper.ROLE);
        _mccWorkflowHelper = (MCCWorkflowHelper) manager.lookup(MCCWorkflowHelper.ROLE);
    }
    
    @Override
    public void updateContents(String initialCatalogName, String newCatalogName, Map<Content, Content> copiedContents, Content targetParentContent)
    {
        for (Content copiedContent : copiedContents.values())
        {
            if (_odfHelper.isContainerOfTypeYear(copiedContent))
            {
                Container container = (Container) copiedContent;
                _mccWorkflowHelper.removeMCCWorkflow(container);
                _mccWorkflowHelper.removeMCCValidatedPDF(container);
            }
        }
    }
}
