/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.odfpilotage.cost.entity;

/**
 * Class representing {@link Effectives}
 */
public class Groups
{
    private Long _overriddenGroups;
    private Long _groupsToOpen;
    private Long _computedGroups;
   
    /**
     * The constructor
     */
    public Groups()
    {
        _groupsToOpen = null;
        _computedGroups = null;
    }

    /**
     * Get the overridden number of groups
     * @return the overridden number of groups, can be <code>null</code> if not defined
     */
    public Long getOverriddenGroups()
    {
        return _overriddenGroups;
    }
    
    /**
     * Set the overridden number of groups
     * @param overriddenGroups the overridden number of groups
     */
    public void setOverriddenGroups(Long overriddenGroups)
    {
        _overriddenGroups = overriddenGroups;
    }
    
    /**
     * Get the groups to open defined on the item, not mandatory
     * @return the number of groups to open, can be <code>null</code> if not defined
     */
    public Long getGroupsToOpen()
    {
        return _groupsToOpen;
    }
    
    /**
     * Set the number of groups to open
     * @param groupsToOpen the number of groups to open
     */
    public void setGroupsToOpen(Long groupsToOpen)
    {
        _groupsToOpen = groupsToOpen;
    }
    
    /**
     * Get the computed groups to open
     * @return the computed number of groups to open
     */
    public Long getComputedGroups()
    {
        return _computedGroups;
    }
    
    /**
     * Set the computed number of groups to open
     * @param computedGroups the computed number of groups to open
     */
    public void setComputedGroups(Long computedGroups)
    {
        _computedGroups = computedGroups;
    }
}
