/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.rule.workflow;

import java.util.Map;

import org.apache.commons.lang3.ArrayUtils;

import org.ametys.cms.repository.ModifiableContent;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.plugins.odfpilotage.rule.RulesManager;
import org.ametys.runtime.i18n.I18nizableText;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;

/**
 * Workflow function to create code on new rules of a thematic.
 */
public class ThematicCodeEditionFunction extends AbstractCodeEditionFunction
{
    public void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException
    {
        WorkflowAwareContent content = getContent(transientVars);
        if (ArrayUtils.contains(content.getTypes(), RulesManager.THEMATIC_CONTENT_TYPE))
        {
            ModifiableContent thematicContent = (ModifiableContent) content;
            _setRulesCode(thematicContent, thematicContent, RulesManager.THEMATIC_RULES);
            content.saveChanges();
        }
    }
    
    public I18nizableText getLabel()
    {
        return new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_THEMATIC_RULE_CODE_EDITION_FUNCTION_LABEL");
    }
}
