/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.rule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.UserIdentity;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.Program;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.BooleanExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.MetadataExpression;
import org.ametys.plugins.repository.query.expression.NotExpression;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ThematicsHelper
implements Component,
Serviceable {
    public static final String ROLE = ThematicsHelper.class.getName();
    public static final String HANDLE_THEMATICS_RIGHT = "ODF_Rights_Thematics_Handle";
    private static final Function<String, Expression> __NOT_EMPTY_ARRAY_EXPRESSION = attributeName -> new Expression((String)attributeName){
        final /* synthetic */ String val$attributeName;
        {
            this.val$attributeName = string;
        }

        public String build() {
            return "jcr:like(ametys:" + this.val$attributeName + ", '_%')";
        }
    };
    private AmetysObjectResolver _resolver;
    private ODFHelper _odfHelper;
    private RightManager _rightManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._odfHelper = (ODFHelper)manager.lookup(ODFHelper.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
    }

    public boolean hasHandleThematicRight() {
        return this._rightManager.currentUserHasRight(HANDLE_THEMATICS_RIGHT, (Object)"/${WorkspaceName}") == RightManager.RightResult.RIGHT_ALLOW;
    }

    public boolean hasHandleThematicRight(UserIdentity user) {
        return this._rightManager.hasRight(user, HANDLE_THEMATICS_RIGHT, (Object)"/${WorkspaceName}") == RightManager.RightResult.RIGHT_ALLOW;
    }

    public List<Content> getCompatibleThematics(String catalog, String degreeId) {
        Map<String, List<String>> restrictions = Map.of("degree", List.of(degreeId));
        return this._getCompatibleThematics(catalog, restrictions);
    }

    public List<Content> getCompatibleThematics(Container container) {
        Map<String, List<String>> restrictions = Map.of("degree", this._getContainerDegrees(container), "regime", this._getRegimeValueAsList((Content)container), "nbSessions", this._getSessionsValueAsList((Content)container));
        return this._getCompatibleThematics(container.getCatalog(), restrictions);
    }

    private List<String> _getSessionsValueAsList(Content content) {
        return Optional.of("mccNbSessions").map(arg_0 -> ((Content)content).getValue(arg_0)).filter(StringUtils::isNotEmpty).map(List::of).orElseGet(List::of);
    }

    private List<String> _getRegimeValueAsList(Content content) {
        return Optional.of("mccRegime").map(arg_0 -> ((Content)content).getValue(arg_0)).filter(Objects::nonNull).map(ContentValue::getContentId).map(List::of).orElseGet(List::of);
    }

    private List<Content> _getCompatibleThematics(String catalog, Map<String, List<String>> restrictions) {
        List<Expression> expressions = this._getCommonThematicExpressions(catalog, true);
        for (String key : restrictions.keySet()) {
            expressions.add(this._getMultipleStringExpressionOrEmpty(key, restrictions.get(key)));
        }
        String query = ContentQueryHelper.getContentXPathQuery((Expression)new AndExpression((Expression[])expressions.toArray(Expression[]::new)));
        return this._resolver.query(query).stream().toList();
    }

    public Content getThematic(String catalog, String thematicCode) {
        List<Expression> expressions = this._getCommonThematicExpressions(catalog, true);
        expressions.add((Expression)new StringExpression("code", Expression.Operator.EQ, thematicCode));
        String query = ContentQueryHelper.getContentXPathQuery((Expression)new AndExpression((Expression[])expressions.toArray(Expression[]::new)));
        return this._resolver.query(query).stream().findFirst().orElse(null);
    }

    public Stream<Content> getThematics(String catalog) {
        List<Expression> expressions = this._getCommonThematicExpressions(catalog, true);
        String query = ContentQueryHelper.getContentXPathQuery((Expression)new AndExpression((Expression[])expressions.toArray(Expression[]::new)));
        return this._resolver.query(query).stream();
    }

    private List<Expression> _getCommonThematicExpressions(String catalog, boolean excludeArchived) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        expressions.add((Expression)new ContentTypeExpression(Expression.Operator.EQ, new String[]{"odf-enumeration.Thematic"}));
        expressions.add((Expression)new StringExpression("catalog", Expression.Operator.EQ, catalog));
        if (excludeArchived) {
            expressions.add((Expression)new NotExpression((Expression)new BooleanExpression("archived", true)));
        }
        return expressions;
    }

    public Stream<Container> getCompatibleContainers(Content thematic, List<Predicate<Container>> additionalPredicates) {
        List nbSessions = Optional.ofNullable((String)thematic.getValue("nbSessions")).filter(StringUtils::isNotEmpty).map(List::of).orElseGet(List::of);
        List<String> regimes = Optional.ofNullable((ContentValue[])thematic.getValue("regime")).map(Stream::of).orElseGet(() -> Stream.of(new ContentValue[0])).map(ContentValue::getContentIfExists).flatMap(Optional::stream).map(AmetysObject::getId).toList();
        List<String> degrees = this._getThematicDegrees(thematic).toList();
        return this.getCompatibleContainers((String)thematic.getValue("catalog"), nbSessions, regimes, degrees, additionalPredicates);
    }

    public Stream<Container> getSimilarContainers(Container container, List<Predicate<Container>> additionalPredicates) {
        List nbSessions = Optional.ofNullable((String)container.getValue("mccNbSessions")).filter(StringUtils::isNotEmpty).map(List::of).orElseGet(List::of);
        List regimes = Optional.ofNullable((ContentValue)container.getValue("mccRegime")).filter(Objects::nonNull).map(ContentValue::getContentId).map(List::of).orElseGet(List::of);
        List<String> degrees = this._getContainerDegrees(container);
        return this.getCompatibleContainers((String)container.getValue("catalog"), nbSessions, regimes, degrees, additionalPredicates);
    }

    public Stream<Container> getCompatibleContainers(String catalog, List<String> nbSessions, List<String> regimes, List<String> degrees, List<Predicate<Container>> additionalPredicates) {
        Optional yearId = this._odfHelper.getYearId();
        if (yearId.isEmpty()) {
            return Stream.of(new Container[0]);
        }
        ArrayList<Object> expressions = new ArrayList<Object>();
        expressions.add(new ContentTypeExpression(Expression.Operator.EQ, new String[]{"org.ametys.plugins.odf.Content.container"}));
        expressions.add(new StringExpression("nature", Expression.Operator.EQ, (String)yearId.get()));
        expressions.add(new StringExpression("catalog", Expression.Operator.EQ, catalog));
        if (!nbSessions.isEmpty()) {
            expressions.add(this._getSingleStringExpressionOrEmpty("mccNbSessions", nbSessions));
        }
        if (!regimes.isEmpty()) {
            expressions.add(this._getSingleStringExpressionOrEmpty("mccRegime", regimes));
        }
        String query = ContentQueryHelper.getContentXPathQuery((Expression)new AndExpression((Expression[])expressions.toArray(Expression[]::new)));
        Stream<Container> containers = this._resolver.query(query).stream();
        for (Predicate<Container> additionalPredicate : additionalPredicates) {
            containers = containers.filter(additionalPredicate);
        }
        Predicate<Container> degreeFilter = degrees.isEmpty() ? __ -> true : c -> this._matchDegree((Container)c, degrees);
        return containers.filter(degreeFilter);
    }

    private boolean _matchDegree(Container container, List<String> degrees) {
        List<String> containerDegrees = this._getContainerDegrees(container);
        if (!containerDegrees.isEmpty()) {
            if (!containerDegrees.stream().anyMatch(degrees::contains)) {
                return false;
            }
        }
        return true;
    }

    private Expression _getSingleStringExpressionOrEmpty(String attributeName, List<String> values) {
        ArrayList<Object> orExpressions = new ArrayList<Object>();
        if (!values.isEmpty()) {
            for (String value : values) {
                orExpressions.add(new StringExpression(attributeName, Expression.Operator.EQ, value));
            }
            orExpressions.add(new NotExpression((Expression)new MetadataExpression(attributeName)));
            orExpressions.add(new StringExpression(attributeName, Expression.Operator.EQ, ""));
        }
        return new OrExpression((Expression[])orExpressions.toArray(Expression[]::new));
    }

    private Expression _getMultipleStringExpressionOrEmpty(String attributeName, List<String> values) {
        ArrayList<Object> orExpressions = new ArrayList<Object>();
        if (!values.isEmpty()) {
            for (String value : values) {
                orExpressions.add(new StringExpression(attributeName, Expression.Operator.EQ, value));
            }
            orExpressions.add(new NotExpression((Expression)new MetadataExpression(attributeName)));
            orExpressions.add(new NotExpression(__NOT_EMPTY_ARRAY_EXPRESSION.apply(attributeName)));
        }
        return new OrExpression((Expression[])orExpressions.toArray(Expression[]::new));
    }

    public String getThematicCode(String ruleCode) {
        return StringUtils.substringBefore((String)ruleCode, (String)"-");
    }

    public boolean areCompatible(Container container, Content thematic) {
        if (!StringUtils.equals((CharSequence)((CharSequence)thematic.getValue("catalog")), (CharSequence)container.getCatalog())) {
            return false;
        }
        if (thematic.hasValue("nbSessions") && container.hasValue("mccNbSessions") && !StringUtils.equals((CharSequence)((CharSequence)thematic.getValue("nbSessions")), (CharSequence)((CharSequence)container.getValue("mccNbSessions")))) {
            return false;
        }
        if (thematic.hasValue("regime") && container.hasValue("mccRegime") && !ArrayUtils.contains((Object[])((Object[])thematic.getValue("regime")), (Object)container.getValue("mccRegime"))) {
            return false;
        }
        List<String> thematicDegrees = this._getThematicDegrees(thematic).toList();
        return thematicDegrees.isEmpty() || this._matchDegree(container, thematicDegrees);
    }

    private List<String> _getContainerDegrees(Container container) {
        return this._odfHelper.getParentPrograms((ProgramItem)container).stream().map(Program::getDegree).filter(StringUtils::isNotEmpty).distinct().toList();
    }

    private Stream<String> _getThematicDegrees(Content thematic) {
        return Optional.ofNullable((ContentValue[])thematic.getValue("degree")).map(Stream::of).orElseGet(() -> Stream.of(new ContentValue[0])).map(ContentValue::getContentId).filter(StringUtils::isNotEmpty);
    }
}

