<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1">

    <xsl:template match="/">
    <text>
    
/**
 * This class is the model for nodes of the program tree.
 * @private
 */
Ext.define('Ametys.plugins.odf.pilotage.tree.CoursePartsContentsTreeModel', {
    extend : 'Ametys.plugins.odf.tree.ODFContentsTreeModel',

    fields : [
        <xsl:for-each select="items[@contentTypeId = 'odf-enumeration.EnseignementNature']/item">
        {
            name: '<xsl:value-of select="@id"/>',
        },
        </xsl:for-each>
        {
            name: 'volumesOfHours',
            convert: function(value, record)
            {
                let v;
                <xsl:for-each select="items[@contentTypeId = 'odf-enumeration.EnseignementNature']/item">
                    v = null;
                    if (value == undefined)
                    {
                        v = null;
                    }
                    else if (!Ext.isObject(value))
                    {
                        v = value;
                    }
                    else if (value['<xsl:value-of select="@id"/>'] != undefined &amp;&amp; value['<xsl:value-of select="@id"/>']['values'] != undefined)
                    {
                        if (value['<xsl:value-of select="@id"/>']['values'].length == 1)
                        {
                            v = value['<xsl:value-of select="@id"/>']['values'][0];
                        }
                        else
                        {
                            v = -1;
                        }
                    }
                    
                    record.set('<xsl:value-of select="@id"/>', v);
                </xsl:for-each>
                
                return value;
            }
        },
        {
            name: 'notEditableDataIndex',
        },
        {
            name: 'notEditableData',
        },
        {
            name: 'contentId',
        }
    ]
});
</text>
</xsl:template>
</xsl:stylesheet>