/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.property;

import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.content.ContentHelper;
import org.ametys.cms.model.properties.AbstractIndexableStaticProperty;
import org.ametys.cms.model.properties.Property;
import org.ametys.odf.program.Container;
import org.ametys.plugins.odfpilotage.helper.PilotageHelper;
import org.ametys.runtime.model.type.ModelItemTypeConstants;

/**
 * {@link Property} to tell if the {@link Container} has invalid data
 */
public class InvalidContainerDataProperty extends AbstractIndexableStaticProperty<Boolean, Boolean, Container> implements Initializable
{
    /** Name of property storing invalid data status */
    public static final String PROPERTY_NAME = "invalidData";
    
    private ContentHelper _contentHelper;
    private PilotageHelper _pilotageHelper;
    
    private boolean _isForceMode; 
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _contentHelper = (ContentHelper) smanager.lookup(ContentHelper.ROLE);
        _pilotageHelper = (PilotageHelper) smanager.lookup(PilotageHelper.ROLE);
    }
    
    @Override
    public void initialize() throws ConfigurationException
    {
        _isForceMode = _pilotageHelper.getMCCRegimePolicy().equals("FORCE");
    }
    
    public Object getValue(Container container)
    {
        return _isForceMode && _contentHelper.validateContent(container).hasErrors();
    }
    
    @Override
    public boolean isMultiple()
    {
        return false;
    }
    
    @Override
    protected String getTypeId()
    {
        return ModelItemTypeConstants.BOOLEAN_TYPE_ID;
    }
}
