/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.manager;

import java.util.Collection;
import java.util.List;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

import org.ametys.cms.contenttype.AbstractContentTypeViewParser;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.search.ui.model.StaticSearchUIModel;
import org.ametys.runtime.model.ItemParserHelper.ConfigurationAndPluginName;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItemAccessor;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItemAccessor;

/**
 * Component that parses view for ODF status restrictions (from /org/ametys/plugins/odfpilotage/manager/restrictions.xml file)
 */
public class ODFStatusRestrictionsViewParser extends AbstractContentTypeViewParser
{
    private static final String __VIEW_NAME = "ODFPilotageStatusRestrictions-attributes";
    
    /** Content types containing the item available in the search model's columns */
    protected ContentType _contentType;

    /**
     * Creates a {@link StaticSearchUIModel}'s columns parser
     * @param contentType The content type containing the item available in restrictions
     */
    public ODFStatusRestrictionsViewParser(ContentType contentType)
    {
        _contentType = contentType;
    }
    
    @Override
    protected String _parseViewName(ConfigurationAndPluginName viewConfiguration) throws ConfigurationException
    {
        return __VIEW_NAME;
    }

    @Override
    public View overrideView(ConfigurationAndPluginName viewConfiguration, View existingView) throws ConfigurationException
    {
        throw new UnsupportedOperationException("Override of a view is not supported for ODF status restrictions");
    }
    
    @Override
    protected void _removeViewItemFromView(View view, Configuration itemConfiguration) throws ConfigurationException
    {
        throw new UnsupportedOperationException("View item removal is not supported for ODF status restrictions");
    }
    
    @Override
    protected void _parseSimpleViewItemGroup(ConfigurationAndPluginName itemConfiguration, String role, ViewItemAccessor parent, Collection<? extends ModelItemAccessor> modelItemAccessors, View referenceView, boolean override) throws ConfigurationException
    {
        throw new UnsupportedOperationException("View item groups are not supported for ODF status restrictions");
    }
    
    @Override
    protected void _fillViewGeneralInformation(ConfigurationAndPluginName viewConfiguration, View view, View existingView, Collection< ? extends Model> model) throws ConfigurationException
    {
        // Do nothing - there is no general information for ODF status restrictions
    }
    
    @Override
    protected Collection<? extends Model> _getModel()
    {
        return List.of(_contentType);
    }
}
