<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:docbook="http://docbook.org/ns/docbook" 
                xmlns:stringutils="org.apache.commons.lang.StringUtils"
                exclude-result-prefixes="docbook stringutils">

    <xsl:import href="Thematic.xsl"/>
    
    <xsl:variable name="common-content-css-class-name">thematic view-main</xsl:variable>
    
    <xsl:template name="common-content-body-title">
        <div class="thematic-header">
            <div>
                <xsl:call-template name="common-content-body-title-content" />
            </div>
            <xsl:apply-templates select="metadata" mode="restrictions"/>
            
            <xsl:if test="metadata/archived = 'true'">
                <div class="rule-tag suspended">
                     <i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_RULES_PREVIEW_TYPE_RULE_SUSPENDED_SHORT" i18n:catalogue="plugin.odf-pilotage"/>
                 </div>
            </xsl:if>
        </div>
    </xsl:template>
    
    <xsl:template name="common-content-body-content">
        <div class="attributes">
            <xsl:apply-templates select="metadata/rules"/>
        </div>
    </xsl:template>
    
    <xsl:template match="metadata" mode="restrictions">
        <div class="thematic-info">
            <div class="info">
                <span class="info-header"><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_TS_CATALOG_LABEL" i18n:catalogue="plugin.odf-pilotage"/><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_SEPARATOR" i18n:catalogue="plugin.odf-pilotage"/></span>
                <xsl:value-of select="catalog"/>
            </div>
            <div class="info">
                <span class="info-header"><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_TS_RESTRICTIONS_DEGREE_LABEL" i18n:catalogue="plugin.odf-pilotage"/><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_SEPARATOR" i18n:catalogue="plugin.odf-pilotage"/></span>
                <xsl:choose>
                    <xsl:when test="degree">
                        <xsl:for-each select="degree">
                            <xsl:value-of select="@title"/>
                            <xsl:if test="position() != last()">, </xsl:if>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_ALL" i18n:catalogue="plugin.odf-pilotage"/></xsl:otherwise>
                </xsl:choose>
            </div>
            <div class="info">
                <span class="info-header"><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_TS_RESTRICTIONS_REGIME_LABEL" i18n:catalogue="plugin.odf-pilotage"/><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_SEPARATOR" i18n:catalogue="plugin.odf-pilotage"/></span>
                <xsl:choose>
                    <xsl:when test="regime">
                        <xsl:for-each select="regime">
                            <xsl:value-of select="@title"/>
                            <xsl:if test="position() != last()">, </xsl:if>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_ALL" i18n:catalogue="plugin.odf-pilotage"/></xsl:otherwise>
                </xsl:choose>
            </div>
            <div class="info">
                <span class="info-header"><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_TS_RESTRICTIONS_NB_SESSIONS_LABEL" i18n:catalogue="plugin.odf-pilotage"/><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_SEPARATOR" i18n:catalogue="plugin.odf-pilotage"/></span>
                <xsl:choose>
                    <xsl:when test="nbSessions">
                        <xsl:for-each select="nbSessions">
                            <xsl:value-of select="."/>
                            <xsl:if test="position() != last()">, </xsl:if>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_ALL" i18n:catalogue="plugin.odf-pilotage"/></xsl:otherwise>
                </xsl:choose>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="rules">
        <div>
            <div class="rules-group">
                <div class="group-header">
                    <h2><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_TS_RULES_LABEL" i18n:catalogue="plugin.odf-pilotage"/></h2>
                </div>
                
                <div class="rules">
                    <div class="rules-table">
                        <table>
                            <xsl:for-each select="entry">
                                <xsl:apply-templates select="." mode="rule"/>
                            </xsl:for-each>
                        </table>
                    </div>
                </div>
                    
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="entry" mode="rule">
        <tr class="status-{stringutils:lowerCase(status/@value)}">
            <td class="rule-code">
                <span class="code"><xsl:value-of select="code"/></span>
            </td>
            <td>
                <div class="rule-header">
                    <xsl:choose>
                        <xsl:when test="status/@value = 'MODIFIED'">
                            <div class="rule-tag modified">
                                <i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_RULES_PREVIEW_TYPE_RULE_MODIFIED_SHORT" i18n:catalogue="plugin.odf-pilotage"/>
                            </div>
                        </xsl:when>
                        <xsl:when test="status/@value = 'NEW'">
                            <div class="rule-tag new">
                                <i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_RULES_PREVIEW_TYPE_RULE_NEW_SHORT" i18n:catalogue="plugin.odf-pilotage"/>
                            </div>
                        </xsl:when>
                        <xsl:when test="status/@value = 'SUSPENDED'">
                            <div class="rule-tag suspended">
                                <i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_RULES_PREVIEW_TYPE_RULE_SUSPENDED_SHORT" i18n:catalogue="plugin.odf-pilotage"/>
                            </div>  
                        </xsl:when>
                        <xsl:otherwise></xsl:otherwise>
                    </xsl:choose>
                    <xsl:if test="isDerogable = 'true'">
                        <div class="rule-tag derogable">
                            <i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_RULES_PREVIEW_TYPE_DEROGABLE" i18n:catalogue="plugin.odf-pilotage"/>
                        </div>
                    </xsl:if>
                </div>
            
                <p><xsl:apply-templates select="text/docbook:article"/></p>
                <xsl:if test="isDerogable = 'true'">
                    <xsl:if test="helpTextDerogation/docbook:article/docbook:para">
                        <p class="attribute-title"><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_TS_RULE_HELP_TEXT_DEROGATION_DISPLAY" i18n:catalogue="plugin.odf-pilotage"/><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_SEPARATOR" i18n:catalogue="plugin.odf-pilotage"/></p>
                        <xsl:apply-templates select="helpTextDerogation/docbook:article"/>
                    </xsl:if>
                    <xsl:if test="helpTextMotivation/docbook:article/docbook:para">
                        <p class="attribute-title"><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_TS_RULE_HELP_TEXT_MOTIVATION_DISPLAY" i18n:catalogue="plugin.odf-pilotage"/><i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_SEPARATOR" i18n:catalogue="plugin.odf-pilotage"/></p>
                        <xsl:apply-templates select="helpTextMotivation/docbook:article"/>
                    </xsl:if>
                </xsl:if>
            </td>
        </tr>
    </xsl:template>
</xsl:stylesheet>
