/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.odfpilotage.clientsideelement;

import java.util.HashMap;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.languages.Language;
import org.ametys.cms.languages.LanguagesManager;
import org.ametys.plugins.contentstree.ui.OpenTreeControllerClientSideElement;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * Override the TreeTooClientSideElement to retrieve informations for the CostModeling 
 */
public class CostModelingButtonClientSideElement extends OpenTreeControllerClientSideElement
{
    /** The Avalon role name */
    public static final String ROLE = CostModelingButtonClientSideElement.class.getName();
    /** The ODF enumeration helper */
    protected LanguagesManager _languagesManager;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _languagesManager = (LanguagesManager) smanager.lookup(LanguagesManager.ROLE); 
    }
    
    @Override
    protected void _lazyConfigure()
    {
        super._lazyConfigure();
        _script.getParameters().put("languages", getLanguages());
    }
    
    /**
     * Retrieve and get all languages in a JSON map 
     * @return a JSON map containing the grid structure for all languages
     */
    public Map<String, I18nizableText> getLanguages()
    {
        Map<String, I18nizableText> languages = new HashMap<>();
        for (Language lang : _languagesManager.getAvailableLanguages().values())
        {
            languages.put(lang.getCode(), lang.getLabel());
            
        }
        return languages;
    }
}
