/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.report.impl;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.cms.repository.ModifiableDefaultContent;
import org.ametys.core.util.DateUtils;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.coursepart.CoursePart;
import org.ametys.odf.enumeration.OdfReferenceTableEntry;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.odfpilotage.helper.ReportHelper;
import org.ametys.plugins.odfpilotage.report.impl.AbstractReport;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ApogeeReport
extends AbstractReport {
    private int _order;

    @Override
    protected String getType(Map<String, String> reportParameters) {
        return "apogee";
    }

    @Override
    public String getDefaultOutputFormat() {
        return "xls";
    }

    @Override
    public Set<String> getSupportedOutputFormats() {
        return Set.of("xls");
    }

    @Override
    public void _saxOrgUnit(ContentHandler handler, String catalog, String lang, String orgUnitId, Map<String, String> reportParameters) {
        OrgUnit orgUnit = (OrgUnit)this._resolver.resolveById(orgUnitId);
        try {
            handler.startDocument();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("type", this.getType());
            XMLUtils.startElement((ContentHandler)handler, (String)"report", (Attributes)attrs);
            this._generateReport(handler, orgUnit, lang, catalog);
            XMLUtils.endElement((ContentHandler)handler, (String)"report");
            handler.endDocument();
        }
        catch (Exception e) {
            this.getLogger().error("An error occured while generating 'Apog\u00e9e' report for orgunit '{}'", (Object)orgUnit.getTitle(), (Object)e);
        }
    }

    private void _generateReport(ContentHandler handler, OrgUnit orgUnit, String lang, String catalog) throws SAXException {
        this._reportHelper.saxNaturesEnseignement(handler, this.getLogger());
        Map<Program, Object> contentsTree = this._getStructure(orgUnit, lang, catalog);
        if (contentsTree.size() > 0) {
            this._order = 1;
            this._saxTree(handler, contentsTree);
        }
    }

    private Map<Program, Object> _getStructure(OrgUnit rootOrgUnit, String lang, String catalog) {
        TreeMap<Content, Map<ProgramItem, Object>> programTree = new TreeMap<Content, Map<ProgramItem, Object>>(ReportHelper.CONTENT_TITLE_COMPARATOR);
        if (rootOrgUnit.getParentOrgUnit() == null || rootOrgUnit.getParentOrgUnit().getParentOrgUnit() == null) {
            List programs = this._odfHelper.getProgramsFromOrgUnit(rootOrgUnit, catalog, lang);
            for (Program program : programs) {
                Map<ProgramItem, Object> courses = this._reportHelper.getCoursesFromContent((ProgramItem)program);
                programTree.put((Content)program, courses);
            }
        }
        return programTree;
    }

    private void _saxTree(ContentHandler handler, Map<Program, Object> programTree) throws SAXException {
        for (Map.Entry<Program, Object> programEntry : programTree.entrySet()) {
            this._saxCourseFromTree(handler, (Map)programEntry.getValue(), programEntry.getKey());
        }
    }

    private void _saxCourseFromTree(ContentHandler handler, Map<ProgramItem, Object> programTree, Program program) throws SAXException {
        this._saxCourseFromTree(handler, programTree, program, null, null, null, null, null, null, 1, "");
    }

    private void _saxCourseFromTree(ContentHandler handler, Map<ProgramItem, Object> tree, Program program, SubProgram subprogram, Container containerYear, Container containerSemester, CourseList list, Integer listPosition, Course parentCourse, int level, String courseHierarchy) throws SAXException {
        int courseListPosition = 0;
        for (Map.Entry<ProgramItem, Object> entry : tree.entrySet()) {
            Object path;
            ProgramItem child = entry.getKey();
            Map subTree = (Map)entry.getValue();
            if (child instanceof Course) {
                Course childCourse = (Course)child;
                path = courseHierarchy + " > " + childCourse.getTitle();
                this._saxCourse(handler, program, subprogram, containerYear, containerSemester, list, listPosition, (Course)child, parentCourse, level, (String)path);
                this._saxCourseFromTree(handler, subTree, program, subprogram, containerYear, containerSemester, list, listPosition, childCourse, level + 1, (String)path);
                continue;
            }
            if (child instanceof Program) {
                Program childProgram = (Program)child;
                this._saxCourseFromTree(handler, subTree, childProgram, subprogram, containerYear, containerSemester, list, listPosition, parentCourse, level, courseHierarchy);
                continue;
            }
            if (child instanceof Container) {
                Container childContainer = (Container)child;
                String containerNature = this._refTableHelper.getItemCode(childContainer.getNature());
                if ("annee".equals(containerNature)) {
                    this._saxCourseFromTree(handler, subTree, program, subprogram, childContainer, containerSemester, list, listPosition, parentCourse, level, courseHierarchy);
                    continue;
                }
                if ("semestre".equals(containerNature)) {
                    this._saxCourseFromTree(handler, subTree, program, subprogram, containerYear, childContainer, list, listPosition, parentCourse, level, courseHierarchy);
                    continue;
                }
                this._saxCourseFromTree(handler, subTree, program, subprogram, containerYear, containerSemester, list, listPosition, parentCourse, level, courseHierarchy);
                continue;
            }
            if (child instanceof SubProgram) {
                SubProgram childSubProgram = (SubProgram)child;
                this._saxCourseFromTree(handler, subTree, program, childSubProgram, containerYear, containerSemester, list, listPosition, parentCourse, level, courseHierarchy);
                continue;
            }
            if (!(child instanceof CourseList)) continue;
            CourseList childCourseList = (CourseList)child;
            path = courseHierarchy.equals("") ? childCourseList.getTitle() : courseHierarchy + " > " + childCourseList.getTitle();
            this._saxCourseFromTree(handler, subTree, program, subprogram, containerYear, containerSemester, childCourseList, ++courseListPosition, parentCourse, level, (String)path);
        }
    }

    private String _getHierarchy(Program program, SubProgram subprogram, Container containerYear, Container containerSemester, String courseHierarchy) {
        Object hierarchy = program.getTitle();
        if (subprogram != null) {
            hierarchy = (String)hierarchy + " > " + subprogram.getTitle();
        }
        if (containerYear != null) {
            hierarchy = (String)hierarchy + " > " + containerYear.getTitle();
        }
        if (containerSemester != null) {
            hierarchy = (String)hierarchy + " > " + containerSemester.getTitle();
        }
        hierarchy = (String)hierarchy + " > " + courseHierarchy;
        return hierarchy;
    }

    private void _saxCourse(ContentHandler handler, Program program, SubProgram subprogram, Container containerYear, Container containerSemester, CourseList list, Integer listPosition, Course course, Course parentCourse, int level, String courseHierarchy) throws SAXException {
        if (course != null) {
            OrgUnit orgUnit;
            String hierarchy = this._getHierarchy(program, subprogram, containerYear, containerSemester, courseHierarchy);
            XMLUtils.startElement((ContentHandler)handler, (String)"course");
            XMLUtils.createElement((ContentHandler)handler, (String)"ordre", (String)String.valueOf(this._order));
            this._saxOrgUnits(handler, program);
            XMLUtils.createElement((ContentHandler)handler, (String)"formation", (String)program.getTitle());
            XMLUtils.createElement((ContentHandler)handler, (String)"formationCode", (String)program.getDisplayCode());
            this._saxSubProgram(handler, subprogram);
            this._saxContainer(handler, containerYear, parentCourse);
            this._saxCourseList(handler, list, listPosition);
            boolean aDesFils = course.hasCourseLists();
            XMLUtils.createElement((ContentHandler)handler, (String)"aDesFils", (String)(aDesFils ? "X" : ""));
            long courseListsSize = course.getParentCourseLists().size();
            XMLUtils.createElement((ContentHandler)handler, (String)"partage", (String)(courseListsSize > 1L ? "X" : ""));
            XMLUtils.createElement((ContentHandler)handler, (String)"occurrences", (String)this._reportHelper.formatNumberToSax(courseListsSize));
            Container etape = this._getEtapePorteuse(course, hierarchy);
            String porte = this._getPorte(etape, containerYear);
            XMLUtils.createElement((ContentHandler)handler, (String)"porte", (String)porte);
            XMLUtils.createElement((ContentHandler)handler, (String)"niveau", (String)("niv" + level));
            XMLUtils.createElement((ContentHandler)handler, (String)"creationDate", (String)DateUtils.zonedDateTimeToString((ZonedDateTime)course.getCreationDate()));
            XMLUtils.createElement((ContentHandler)handler, (String)"codeApogee", (String)((String)course.getValue("elpCode", false, (Object)"")));
            XMLUtils.createElement((ContentHandler)handler, (String)"nature", (String)this._refTableHelper.getItemCode(course.getCourseType()));
            XMLUtils.createElement((ContentHandler)handler, (String)"libelleCourt", (String)((String)course.getValue("shortLabel", false, (Object)"")));
            XMLUtils.createElement((ContentHandler)handler, (String)"libelle", (String)course.getTitle());
            XMLUtils.createElement((ContentHandler)handler, (String)"elpCode", (String)course.getDisplayCode());
            this._reportHelper.saxContentAttribute(handler, (ModifiableDefaultContent)course, "campus", "campus");
            XMLUtils.createElement((ContentHandler)handler, (String)"ects", (String)String.valueOf(course.getEcts()));
            String teachingActivity = this._refTableHelper.getItemCode(course.getTeachingActivity());
            String stage = teachingActivity.equals("SA") ? "X" : "";
            XMLUtils.createElement((ContentHandler)handler, (String)"stage", (String)stage);
            Content period = Optional.of("period").map(arg_0 -> ((Course)course).getValue(arg_0)).flatMap(ContentValue::getContentIfExists).orElse(null);
            if (period != null) {
                try {
                    String periodCode = Optional.of("code").map(arg_0 -> ((Content)period).getValue(arg_0)).orElse("");
                    String periodTypeCode = Optional.ofNullable((ContentValue)period.getValue("type")).flatMap(ContentValue::getContentIfExists).map(c -> (String)c.getValue("code")).orElse("");
                    XMLUtils.createElement((ContentHandler)handler, (String)"periode", (String)("s10".equals(periodCode) ? "s0" : periodCode));
                    XMLUtils.createElement((ContentHandler)handler, (String)"periodeType", (String)periodTypeCode);
                }
                catch (UnknownAmetysObjectException e) {
                    this.getLogger().error("Impossible de retrouver la p\u00e9riode : {}", (Object)period, (Object)e);
                }
            }
            XMLUtils.createElement((ContentHandler)handler, (String)"codeComposante", (String)((orgUnit = this._getOrgUnit(course, hierarchy)) != null ? (String)orgUnit.getValue("codCmp", false, (Object)"") : ""));
            XMLUtils.createElement((ContentHandler)handler, (String)"codeCIP", (String)(orgUnit != null ? (String)orgUnit.getValue("codCipApogee", false, (Object)"") : ""));
            long codeAnu = (Long)course.getValue("CodeAnu", false, (Object)0L);
            XMLUtils.createElement((ContentHandler)handler, (String)"CodeAnu", (String)(codeAnu > 0L ? String.valueOf(codeAnu) : ""));
            XMLUtils.createElement((ContentHandler)handler, (String)"calculCharges", (String)(aDesFils ? "" : "X"));
            for (CoursePart coursePart : course.getCourseParts()) {
                AttributesImpl attr = new AttributesImpl();
                attr.addCDATAAttribute("nature", coursePart.getNature());
                XMLUtils.createElement((ContentHandler)handler, (String)"volumeHoraire", (Attributes)attr, (String)String.valueOf(coursePart.getNumberOfHours()));
            }
            if (etape != null) {
                XMLUtils.createElement((ContentHandler)handler, (String)"etapePorteuse", (String)((String)etape.getValue("etpCode", false, (Object)"")));
                XMLUtils.createElement((ContentHandler)handler, (String)"vetEtapePorteuse", (String)((String)etape.getValue("vrsEtpCode", false, (Object)"")));
            }
            String disciplineEnseignement = Optional.of("disciplineEnseignement").map(arg_0 -> ((Course)course).getValue(arg_0)).flatMap(ContentValue::getContentIfExists).map(OdfReferenceTableEntry::new).map(entry -> {
                String code = entry.getCode();
                return (String)(StringUtils.isNotEmpty((CharSequence)code) ? "[" + code + "] " : "") + entry.getLabel(course.getLanguage());
            }).orElse("");
            XMLUtils.createElement((ContentHandler)handler, (String)"discipline", (String)disciplineEnseignement);
            XMLUtils.endElement((ContentHandler)handler, (String)"course");
            ++this._order;
        }
    }

    private void _saxContainer(ContentHandler handler, Container container, Course parentCourse) throws AmetysRepositoryException, SAXException {
        if (container != null) {
            XMLUtils.createElement((ContentHandler)handler, (String)"annee", (String)container.getTitle());
            XMLUtils.createElement((ContentHandler)handler, (String)"COD_ETP", (String)((String)container.getValue("etpCode", false, (Object)"")));
            XMLUtils.createElement((ContentHandler)handler, (String)"COD_VRS_ETP", (String)((String)container.getValue("vrsEtpCode", false, (Object)"")));
            XMLUtils.createElement((ContentHandler)handler, (String)"codeELPPere", (String)(parentCourse != null ? parentCourse.getCode() : ""));
        }
    }

    private void _saxSubProgram(ContentHandler handler, SubProgram subprogram) throws AmetysRepositoryException, SAXException {
        if (subprogram != null) {
            XMLUtils.createElement((ContentHandler)handler, (String)"parcours", (String)subprogram.getTitle());
            XMLUtils.createElement((ContentHandler)handler, (String)"parcoursCode", (String)subprogram.getDisplayCode());
        }
    }

    private void _saxOrgUnits(ContentHandler handler, Program program) throws SAXException {
        StringBuilder sb = new StringBuilder();
        List orgUnits = program.getOrgUnits();
        for (String orgUnitId : orgUnits) {
            try {
                OrgUnit orgUnit = (OrgUnit)this._resolver.resolveById(orgUnitId);
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(orgUnit.getTitle());
                sb.append(" (");
                sb.append(orgUnit.getUAICode());
                sb.append(")");
            }
            catch (UnknownAmetysObjectException e) {
                this.getLogger().info("La composante r\u00e9f\u00e9renc\u00e9e par la formation {} ({}) n'a pas \u00e9t\u00e9 trouv\u00e9e.", (Object)program.getTitle(), (Object)program.getCode());
            }
        }
        XMLUtils.createElement((ContentHandler)handler, (String)"orgUnit", (String)sb.toString());
    }

    private String _getPorte(Container etape, Container containerYear) {
        String etpCode;
        String porte = "";
        if (etape != null && containerYear != null && StringUtils.isNotEmpty((CharSequence)(etpCode = (String)containerYear.getValue("etpCode", false, (Object)"")))) {
            porte = etpCode.equals(etape.getValue("etpCode", false, (Object)"")) ? "X" : "";
        }
        return porte;
    }

    private OrgUnit _getOrgUnit(Course course, String hierarchy) {
        OrgUnit orgUnit = null;
        List courseOrgUnits = course.getOrgUnits();
        if (!courseOrgUnits.isEmpty()) {
            try {
                orgUnit = (OrgUnit)this._resolver.resolveById((String)courseOrgUnits.get(0));
            }
            catch (UnknownAmetysObjectException e) {
                this.getLogger().info("La composante r\u00e9f\u00e9renc\u00e9e par l'\u00e9l\u00e9ment p\u00e9dagogique {} ({}) n'a pas \u00e9t\u00e9 trouv\u00e9e.", (Object)hierarchy, (Object)course.getCode());
            }
            if (courseOrgUnits.size() > 1) {
                this.getLogger().warn("L'\u00e9l\u00e9ment p\u00e9dagogique {} ({}) r\u00e9f\u00e9rence plus d'une composante.", (Object)hierarchy, (Object)course.getCode());
            }
        }
        return orgUnit;
    }

    private Container _getEtapePorteuse(Course course, String hierarchy) {
        return Optional.ofNullable((ContentValue)course.getValue("etapePorteuse")).flatMap(contentValue -> this._getEtapePorteuseIfExists((ContentValue)contentValue, course, hierarchy)).map(Container.class::cast).orElse(null);
    }

    private Optional<ModifiableContent> _getEtapePorteuseIfExists(ContentValue etapePorteuse, Course course, String hierarchy) {
        try {
            return Optional.ofNullable(etapePorteuse.getContent());
        }
        catch (UnknownAmetysObjectException e) {
            this.getLogger().info("L'ann\u00e9e porteuse r\u00e9f\u00e9renc\u00e9e par l'\u00e9l\u00e9ment p\u00e9dagogique {} ({}) n'a pas \u00e9t\u00e9 trouv\u00e9e.", (Object)hierarchy, (Object)course.getCode());
            return Optional.empty();
        }
    }

    private void _saxCourseList(ContentHandler handler, CourseList list, Integer position) throws SAXException {
        if (list != null) {
            XMLUtils.createElement((ContentHandler)handler, (String)"list", (String)("Lst" + position));
            this._saxChoiceList(handler, list);
        }
    }

    private void _saxChoiceList(ContentHandler handler, CourseList list) throws SAXException {
        CourseList.ChoiceType typeList = list.getType();
        if (typeList != null) {
            if (typeList.name() != null && (typeList.name().equals(CourseList.ChoiceType.CHOICE.toString()) || typeList.name().equals(CourseList.ChoiceType.MANDATORY.toString()) || typeList.name().equals(CourseList.ChoiceType.OPTIONAL.toString()))) {
                String typeListAsString = "";
                if (typeList.name().equals(CourseList.ChoiceType.CHOICE.toString())) {
                    typeListAsString = "X";
                } else if (typeList.name().equals(CourseList.ChoiceType.MANDATORY.toString())) {
                    typeListAsString = "O";
                } else if (typeList.name().equals(CourseList.ChoiceType.OPTIONAL.toString())) {
                    typeListAsString = "F";
                }
                XMLUtils.createElement((ContentHandler)handler, (String)"typeList", (String)typeListAsString);
            }
            if (typeList.name() != null && typeList.name().equals(CourseList.ChoiceType.CHOICE.toString())) {
                XMLUtils.createElement((ContentHandler)handler, (String)"minmax", (String)this._reportHelper.formatNumberToSax(list.getMinNumberOfCourses()));
            }
        }
    }
}

