/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.odfpilotage.cost.entity;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

import org.ametys.odf.program.Program;
import org.ametys.plugins.odfpilotage.cost.CostComputationComponent;

/**
 * This class store all of the information computed by the {@link CostComputationComponent}
 */
public class CostComputationData extends HashMap<String, ProgramItemData>
{
    private Set<Program> _computedPrograms;
    
    /**
     * Constructor
     * @param computedPrograms programs on which the computation is done
     */
    public CostComputationData(Collection<Program> computedPrograms)
    {
        _computedPrograms = new HashSet<>(computedPrograms);
    }
    
    /**
     * Get the programs concerned by the cost computation.
     * @return A {@link Set} of {@link Program}
     */
    public Set<Program> getComputedPrograms()
    {
        return _computedPrograms;
    }
}
