/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.rule.clientsideelement;

import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.odf.program.ContainerFactory;
import org.ametys.plugins.odfpilotage.rule.RulesManager;
import org.ametys.runtime.model.View;

/**
 * This element creates a ribbon button to edit specific rules
 */
public class SpecificRulesClientSideElement extends RulesSmartContentClientSideElement
{
    /** The content type extention point */
    protected ContentTypeExtensionPoint _cTypeEP;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _cTypeEP = (ContentTypeExtensionPoint) manager.lookup(ContentTypeExtensionPoint.ROLE);
    }
    
    @Override
    public List<Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters)
    {
        ContentType containerType = _cTypeEP.getExtension(ContainerFactory.CONTAINER_CONTENT_TYPE);
        View view = containerType.getView(RulesManager.SPECIFIC_RULE_VIEW);
        return view != null
            ? super.getScripts(ignoreRights, contextParameters)
            : List.of();
    }
}
