/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.report.impl;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.coursepart.CoursePart;
import org.ametys.odf.enumeration.OdfReferenceTableEntry;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.odfpilotage.helper.PilotageHelper;
import org.ametys.plugins.odfpilotage.report.impl.AbstractReport;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class VolumeHoraireReport
extends AbstractReport {
    private static final Map<CourseList.ChoiceType, String> __COURSELIST_TYPE_2_LABEL = ImmutableMap.of((Object)CourseList.ChoiceType.MANDATORY, (Object)"Obligatoire", (Object)CourseList.ChoiceType.OPTIONAL, (Object)"Facultatif", (Object)CourseList.ChoiceType.CHOICE, (Object)"A choix");
    private String _natureSemester;
    private String _natureYear;
    private String _natureUE;

    @Override
    protected String getType(Map<String, String> reportParameters) {
        return "volumehoraire";
    }

    @Override
    public String getDefaultOutputFormat() {
        return "xls";
    }

    @Override
    public Set<String> getSupportedOutputFormats() {
        return Set.of("xls");
    }

    @Override
    public void _saxOrgUnit(ContentHandler handler, String catalog, String lang, String orgUnitId, Map<String, String> reportParameters) {
        this._natureYear = this._odfHelper.getYearId().orElse(null);
        this._natureSemester = Optional.of(this._refTableHelper.getItemFromCode("odf-enumeration.ContainerNature", "semestre")).map(OdfReferenceTableEntry::getId).orElse(null);
        this._natureUE = Optional.ofNullable(this._refTableHelper.getItemFromCode("odf-enumeration.CourseNature", "UE")).map(OdfReferenceTableEntry::getId).orElse(null);
        OrgUnit orgUnit = (OrgUnit)this._resolver.resolveById(orgUnitId);
        List selectedPrograms = this._odfHelper.getProgramsFromOrgUnit(orgUnit, catalog, lang);
        Map<String, Map<String, String>> calculatedElps = this._volumeHoraire(selectedPrograms);
        try {
            handler.startDocument();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("type", this.getType());
            XMLUtils.startElement((ContentHandler)handler, (String)"report", (Attributes)attrs);
            this._reportHelper.saxNaturesEnseignement(handler, this.getLogger());
            XMLUtils.startElement((ContentHandler)handler, (String)"lines");
            for (Program program : selectedPrograms) {
                this._saxUEsForProgram(handler, program, calculatedElps);
            }
            XMLUtils.endElement((ContentHandler)handler, (String)"lines");
            XMLUtils.endElement((ContentHandler)handler, (String)"report");
            handler.endDocument();
        }
        catch (Exception e) {
            this.getLogger().error("An error occured while generating 'Volume horaire' report for orgunit '{}'", (Object)orgUnit.getTitle(), (Object)e);
        }
    }

    private Map<String, Map<String, String>> _volumeHoraire(List<Program> selectedPrograms) {
        HashMap<String, Map<String, String>> calculatedElps = new HashMap<String, Map<String, String>>();
        Set<Course> courses = this._getUEsFromPrograms(selectedPrograms);
        for (Course course : courses) {
            String coursePrefix = course.getTitle();
            this.getLogger().info("[{}] Calcul des volumes horaires...", (Object)coursePrefix);
            Map<String, Pair<Double, Double>> volumesByNature = this._calculVolumeByEnseignement(course, 1.0f);
            HashMap<Object, String> ueData = new HashMap<Object, String>();
            ContentValue periodValue = (ContentValue)course.getValue("period");
            if (periodValue != null) {
                try {
                    ModifiableContent period = periodValue.getContent();
                    String periodType = Optional.ofNullable((ContentValue)period.getValue("type")).flatMap(ContentValue::getContentIfExists).map(OdfReferenceTableEntry::new).map(OdfReferenceTableEntry::getCode).orElse("");
                    ueData.put("periode", period.getTitle());
                    ueData.put("typePeriode", periodType);
                }
                catch (UnknownAmetysObjectException e) {
                    this.getLogger().error("Impossible de retrouver la p\u00e9riode : {}", (Object)periodValue, (Object)e);
                }
            }
            ueData.put("code", course.getDisplayCode());
            ueData.put("codeELP", (String)course.getValue("elpCode", false, (Object)""));
            ueData.put("shortLabel", (String)course.getValue("shortLabel", false, (Object)""));
            ueData.put("title", course.getTitle());
            Double ects = (Double)course.getValue("ects");
            ueData.put("ects", ects == null ? "" : String.valueOf(ects));
            Set<Container> steps = this._pilotageHelper.getSteps((ProgramItem)course);
            ueData.put("isShared", steps.size() > 1 ? "X" : "");
            Pair<PilotageHelper.StepHolderStatus, Container> stepHolder = this._pilotageHelper.getStepHolder((ProgramItem)course);
            if (((PilotageHelper.StepHolderStatus)((Object)stepHolder.getKey())).equals((Object)PilotageHelper.StepHolderStatus.SINGLE)) {
                ueData.put("stepHolder", this._getStepHolder((Container)stepHolder.getValue()));
            }
            for (String nature : volumesByNature.keySet()) {
                Pair<Double, Double> volumes = volumesByNature.get(nature);
                ueData.put("nbHours#" + nature + "#average", String.valueOf(volumes.getLeft()));
                ueData.put("nbHours#" + nature + "#total", String.valueOf(volumes.getRight()));
            }
            calculatedElps.put(course.getId(), ueData);
        }
        return calculatedElps;
    }

    private String _getStepHolder(Container stepHolder) {
        StringBuilder stepHolderAsString = new StringBuilder(stepHolder.getDisplayCode()).append("#");
        ArrayList etpCodes = new ArrayList();
        Optional.ofNullable(stepHolder.getValue("etpCode")).map(String.class::cast).filter(StringUtils::isNotEmpty).ifPresent(etpCodes::add);
        Optional.ofNullable(stepHolder.getValue("vrsEtpCode")).map(String.class::cast).filter(StringUtils::isNotEmpty).ifPresent(etpCodes::add);
        if (!etpCodes.isEmpty()) {
            stepHolderAsString.append("[").append(StringUtils.join(etpCodes, (String)"-")).append("] ");
        }
        stepHolderAsString.append(stepHolder.getTitle());
        return stepHolderAsString.toString();
    }

    private Set<Course> _getUEsFromPrograms(List<Program> selectedPrograms) {
        LinkedHashSet<Course> courses = new LinkedHashSet<Course>();
        if (this._natureUE != null) {
            selectedPrograms.forEach(program -> courses.addAll(this._getCoursesForProgramItem((ProgramItem)program)));
        }
        return courses;
    }

    private List<Course> _getCoursesForProgramItem(ProgramItem programItem) {
        Course course;
        ArrayList<Course> courses = new ArrayList<Course>();
        if (programItem instanceof Course && this._natureUE.equals((course = (Course)programItem).getCourseType())) {
            courses.add(course);
        } else {
            this._odfHelper.getChildProgramItems(programItem).forEach(child -> courses.addAll(this._getCoursesForProgramItem((ProgramItem)child)));
        }
        return courses;
    }

    private Map<String, Pair<Double, Double>> _calculVolumeByEnseignement(CourseList courseList, float initialWeight, Map<String, Pair<Double, Double>> volumesByNature) {
        float weight;
        Map<String, Pair<Double, Double>> volumes = volumesByNature;
        CourseList.ChoiceType courseListType = courseList.getType();
        if (courseListType == null) {
            this.getLogger().error("The list '{}' ({}) doesn't have a valid type.", (Object)courseList.getTitle(), (Object)courseList.getCode());
        } else if (!courseListType.equals((Object)CourseList.ChoiceType.OPTIONAL) && courseList.hasCourses() && (weight = initialWeight * this._getWeight(courseList)) > 0.0f) {
            for (Course course : courseList.getCourses()) {
                Map<String, Pair<Double, Double>> courseVolumes = this._calculVolumeByEnseignement(course, weight);
                for (String nature : courseVolumes.keySet()) {
                    Pair<Double, Double> courseVolume = courseVolumes.getOrDefault(nature, (Pair<Double, Double>)Pair.of((Object)0.0, (Object)0.0));
                    Pair<Double, Double> volume = volumes.getOrDefault(nature, (Pair<Double, Double>)Pair.of((Object)0.0, (Object)0.0));
                    volumes.put(nature, (Pair<Double, Double>)Pair.of((Object)((Double)courseVolume.getLeft() + (Double)volume.getLeft()), (Object)((Double)courseVolume.getRight() + (Double)volume.getRight())));
                }
            }
        }
        return volumes;
    }

    private float _getWeight(CourseList courseList) {
        CourseList.ChoiceType courseListType = courseList.getType();
        if (!courseListType.equals((Object)CourseList.ChoiceType.OPTIONAL) && courseList.hasCourses()) {
            if (courseListType.equals((Object)CourseList.ChoiceType.MANDATORY)) {
                return 1.0f;
            }
            if (courseListType.equals((Object)CourseList.ChoiceType.CHOICE)) {
                return (float)courseList.getMinNumberOfCourses() / (float)courseList.getCourses().size();
            }
        }
        return 0.0f;
    }

    private Map<String, Pair<Double, Double>> _calculVolumeByEnseignement(Course course, float weight) {
        Map<String, Pair<Double, Double>> volumesByNature = new HashMap<String, Pair<Double, Double>>();
        if (course.hasCourseLists()) {
            for (CourseList courseList : course.getCourseLists()) {
                volumesByNature = this._calculVolumeByEnseignement(courseList, weight, volumesByNature);
            }
        } else {
            HashMap<String, Double> volumes = new HashMap<String, Double>();
            for (CoursePart coursePart : course.getCourseParts()) {
                String nature = coursePart.getNature();
                double nbHours = coursePart.getNumberOfHours();
                volumes.put(nature, volumes.getOrDefault(nature, 0.0) + nbHours);
            }
            for (String nature : volumes.keySet()) {
                Double nbHours = (Double)volumes.get(nature);
                volumesByNature.put(nature, (Pair<Double, Double>)Pair.of((Object)(nbHours * (double)weight), (Object)nbHours));
            }
        }
        return volumesByNature;
    }

    private void _saxUEsForProgram(ContentHandler handler, Program program, Map<String, Map<String, String>> calculatedElps) throws SAXException {
        this._saxUEsWithStructure(handler, (ProgramItem)program, new HashMap<String, String>(), calculatedElps, 1.0f);
    }

    private void _saxUEsWithStructure(ContentHandler handler, ProgramItem programItem, Map<String, String> structureData, Map<String, Map<String, String>> calculatedElps, float initialWeight) throws SAXException {
        float weight = initialWeight;
        HashMap<String, String> currentStructureData = new HashMap<String, String>(structureData);
        String title = ((Content)programItem).getTitle();
        if (programItem instanceof Program) {
            Program program = (Program)programItem;
            currentStructureData.put("program", title);
            String degree = this._refTableHelper.getItemLabel(program.getDegree(), program.getLanguage());
            currentStructureData.put("degree", degree);
        } else if (programItem instanceof SubProgram) {
            currentStructureData.put("parcours", title);
        } else if (programItem instanceof Container) {
            Container container = (Container)programItem;
            String containerNature = container.getNature();
            if (containerNature.equals(this._natureSemester)) {
                currentStructureData.put("semestre", title);
            } else if (containerNature.equals(this._natureYear)) {
                currentStructureData.put("annee", title);
                currentStructureData.put("etpCode", (String)container.getValue("etpCode", false, (Object)""));
                currentStructureData.put("vrsEtpCode", (String)container.getValue("vrsEtpCode", false, (Object)""));
            }
        } else if (programItem instanceof CourseList) {
            CourseList courseList = (CourseList)programItem;
            if (!currentStructureData.containsKey("listType")) {
                CourseList.ChoiceType courseListType = courseList.getType();
                if (courseListType == null) {
                    this.getLogger().error("The course list '{}' hasn't a type.", (Object)title);
                } else {
                    String courseListTypeTraduction = __COURSELIST_TYPE_2_LABEL.get(courseListType);
                    if (courseListTypeTraduction == null) {
                        this.getLogger().error("Invalid course list type '{}' for '{}'.", (Object)courseListType, (Object)title);
                    } else {
                        currentStructureData.put("listType", courseListTypeTraduction);
                    }
                    weight *= this._getWeight(courseList);
                }
            }
        } else if (programItem instanceof Course) {
            Map<String, String> ueData;
            Course course = (Course)programItem;
            if (!currentStructureData.containsKey("CodeAnu")) {
                String codeAnu = Optional.ofNullable(course.getValue("CodeAnu")).map(codeAsLong -> String.valueOf(codeAsLong)).orElse("");
                currentStructureData.put("CodeAnu", codeAnu);
            }
            if ((ueData = calculatedElps.get(course.getId())) != null) {
                this._saxUE(handler, currentStructureData, ueData, weight);
            }
        }
        for (ProgramItem child : this._odfHelper.getChildProgramItems(programItem)) {
            this._saxUEsWithStructure(handler, child, currentStructureData, calculatedElps, weight);
        }
    }

    private void _saxUE(ContentHandler handler, Map<String, String> structureData, Map<String, String> ueData, float weight) throws SAXException {
        XMLUtils.startElement((ContentHandler)handler, (String)"line");
        for (Map.Entry<String, String> cell : structureData.entrySet()) {
            XMLUtils.createElement((ContentHandler)handler, (String)cell.getKey(), (String)cell.getValue());
        }
        for (Map.Entry<String, String> cell : ueData.entrySet()) {
            String key = cell.getKey();
            if ("stepHolder".equals(key)) {
                this._stepHolderToSAX(handler, cell.getValue());
                continue;
            }
            if (key.startsWith("nbHours#")) {
                AttributesImpl cellAttrs = new AttributesImpl();
                String[] tokens = key.split("#");
                key = tokens[0];
                cellAttrs.addCDATAAttribute("nature", tokens[1]);
                cellAttrs.addCDATAAttribute("type", tokens[2]);
                String value = tokens[2].equals("average") ? String.valueOf(Double.parseDouble(cell.getValue()) * (double)weight) : cell.getValue();
                XMLUtils.createElement((ContentHandler)handler, (String)key, (Attributes)cellAttrs, (String)value);
                continue;
            }
            XMLUtils.createElement((ContentHandler)handler, (String)key, (String)cell.getValue());
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"line");
    }

    private void _stepHolderToSAX(ContentHandler handler, String stepAsString) throws SAXException {
        XMLUtils.startElement((ContentHandler)handler, (String)"stepHolder");
        String[] tokens = stepAsString.split("#");
        XMLUtils.createElement((ContentHandler)handler, (String)"code", (String)tokens[0]);
        XMLUtils.createElement((ContentHandler)handler, (String)"title", (String)tokens[1]);
        XMLUtils.endElement((ContentHandler)handler, (String)"stepHolder");
    }
}

