/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.rule.observations;

import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.jcr.RepositoryException;
import javax.jcr.Session;

import org.ametys.cms.ObservationConstants;
import org.ametys.cms.data.holder.group.ModifiableIndexableRepeaterEntry;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.odf.program.Container;
import org.ametys.plugins.odfpilotage.rule.RulesManager;
import org.ametys.plugins.repository.jcr.DefaultAmetysObject;

/**
 * Observer to remove derogation and additional rule if the thematic is deleted.
 */
public class ThematicDeletionObserver extends AbstractThematicRulesObserver
{
    @Override
    protected String getSupportedEventId()
    {
        return ObservationConstants.EVENT_CONTENT_DELETING;
    }
    
    @Override
    protected Map<Container, Set<Integer>> getRulePositionsToDelete(ModifiableContent content, String catalog, String thematicCode, List< ? extends ModifiableIndexableRepeaterEntry> ruleEntries) throws RepositoryException
    {
        List<String> ruleCodes = ruleEntries.stream()
                .map(e -> e.<String>getValue(RulesManager.RULE_CODE))
                .toList();
        
        Session session = ((DefaultAmetysObject) content).getNode().getSession();
        return _getContainerRulePositions(session, catalog, thematicCode, ruleCodes, true);
    }
}
