/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.rule.observations;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.data.holder.group.ModifiableIndexableRepeater;
import org.ametys.cms.data.holder.group.ModifiableIndexableRepeaterEntry;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.core.observation.Event;
import org.ametys.odf.program.Container;
import org.ametys.plugins.odfpilotage.rule.RulesManager;
import org.ametys.plugins.odfpilotage.rule.observations.AbstractRulesStepObserver;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.holder.group.RepeaterEntry;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public abstract class AbstractThematicRulesObserver
extends AbstractRulesStepObserver {
    protected AmetysObjectResolver _resolver;
    protected ContentTypesHelper _contentTypesHelper;
    protected RulesManager _rulesManager;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._contentTypesHelper = (ContentTypesHelper)manager.lookup(ContentTypesHelper.ROLE);
        this._rulesManager = (RulesManager)((Object)manager.lookup(RulesManager.ROLE));
    }

    @Override
    protected boolean supportsContent(Content content) {
        return this._contentTypesHelper.isInstanceOf(content, "odf-enumeration.Thematic");
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        ModifiableContent content = (ModifiableContent)event.getArguments().get("content");
        String catalog = (String)content.getValue("catalog");
        String thematicCode = (String)content.getValue("code");
        List ruleEntries = Optional.ofNullable(content).map(c -> (ModifiableIndexableRepeater)c.getValue("rules")).map(ModifiableIndexableRepeater::getEntries).map(Collection::stream).orElseGet(() -> Stream.of(new ModifiableIndexableRepeaterEntry[0])).toList();
        Map<Container, Set<Integer>> rulePositionsToDelete = this.getRulePositionsToDelete(content, catalog, thematicCode, ruleEntries);
        for (Container container : rulePositionsToDelete.keySet()) {
            this._rulesManager.deleteRules(container, rulePositionsToDelete.get(container));
        }
    }

    protected abstract Map<Container, Set<Integer>> getRulePositionsToDelete(ModifiableContent var1, String var2, String var3, List<? extends ModifiableIndexableRepeaterEntry> var4) throws RepositoryException;

    protected Map<Container, Set<Integer>> _getContainerRulePositions(Session session, String catalog, String thematicCode, List<String> ruleCodes, boolean withAdditional) throws RepositoryException {
        StringBuilder queryString = new StringBuilder("//element(*, ametys:container)");
        queryString.append("[@ametys:catalog = '").append(catalog).append("']/ametys:rules/*[");
        queryString.append("@ametys:thematicCode = '").append(thematicCode).append("'");
        for (String code : ruleCodes) {
            queryString.append(" or @ametys:code = '").append(code).append("'");
        }
        queryString.append("]");
        return this._getContainers(session, queryString.toString()).stream().collect(Collectors.toMap(Function.identity(), c -> this._getRulePositions((Container)c, e -> this._matchRule((ModifiableIndexableRepeaterEntry)e, ruleCodes, withAdditional))));
    }

    private boolean _matchRule(ModifiableIndexableRepeaterEntry entry, List<String> ruleCodes, boolean withAdditional) {
        if (entry.hasValue("thematicCode")) {
            return withAdditional;
        }
        return ruleCodes.contains(entry.getValue("code"));
    }

    private Set<Integer> _getRulePositions(Container container, Predicate<ModifiableIndexableRepeaterEntry> filter) {
        return Optional.ofNullable(container).map(c -> (ModifiableIndexableRepeater)c.getValue("rules")).map(ModifiableIndexableRepeater::getEntries).map(Collection::stream).orElseGet(() -> Stream.of(new ModifiableIndexableRepeaterEntry[0])).filter(filter).map(RepeaterEntry::getPosition).collect(Collectors.toSet());
    }

    private Set<Container> _getContainers(Session session, String queryAsString) throws RepositoryException {
        HashSet<Container> containers = new HashSet<Container>();
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(queryAsString, "xpath");
        NodeIterator nodeIterator = query.execute().getNodes();
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.nextNode();
            containers.add(this._getParentContainer(node));
        }
        return containers;
    }

    private Container _getParentContainer(Node node) {
        try {
            for (Node parent = node.getParent(); parent != null; parent = parent.getParent()) {
                if (!parent.getPrimaryNodeType().isNodeType("ametys:container")) continue;
                return (Container)this._resolver.resolve(parent, false);
            }
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred getting the parent container", (Throwable)e);
        }
        throw new AmetysRepositoryException("We should find a parent container from node : " + String.valueOf(node));
    }
}

