  /*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

const OdfHelper = Ametys.serviceManager.lookup("org.ametys.odf.ODFHelper");
const PilotageHelper = Ametys.serviceManager.lookup("org.ametys.plugins.odfpilotage.helper.PilotageHelper");
const SolrIndexer = Ametys.serviceManager.lookup("org.ametys.cms.content.indexing.solr.SolrIndexer");

logger.info("Migrate MCC status on years to apply new control steps");

let containers = Repository.query("//element(*, ametys:container)");
let total = containers.getSize();
let updated = 0;
let handled = 0;
let hasChanges = false;
let updatedContainers = [];

containers.forEach(
    container =>
    {
		hasChanges = false;
		        
        Content.migrate( 
            container, 
            [_migrateMCCStatus], 
            true, /* old version still comptatible */ 
            null, /* no tag */ 
            false, /* verbose */
            true /* synchronize live */
        );
        
        if (hasChanges)
        {
            updated++;
			try
			{
				// reindex content
				SolrIndexer.indexContent(container.getId(), false);
			}
			catch(e) {}
        }
                
        handled++;
        
        if (handled % 200 == 0)
        {
            logger.info(`${handled} handled containers`);
        }
    }
);

logger.info(`MCC status has been migrated for ${updated} years on a total of ${total} containers.`);

function _migrateMCCStatus(container)
{
	if (!PilotageHelper.isContainerOfTypeYear(container))
	{
		return;		
	}
	
    var mccComposite = container.getComposite("mcc_workflow", true);
	let ouValidated = mccComposite.getValue("mcc_orgunit_validation_status", false, false);
	if (ouValidated)
	{
		mccComposite.setValue("mcc_orgunit_control_status", true);
		
		// Copy orgunit validation step to orgunit control step
		Repository.helper.setModelAwareValue(mccComposite, "mcc_orgunit_control_date", mccComposite.getValue("mcc_orgunit_validation_date"));
		Repository.helper.setModelAwareValue(mccComposite, "mcc_orgunit_control_author", mccComposite.getValue("mcc_orgunit_validation_author"));
		Repository.helper.setModelAwareValue(mccComposite, "mcc_orgunit_control_comment", mccComposite.getValue("mcc_orgunit_validation_comment"));
		
		hasChanges = true;
	}
	
	let cfvuValidated = mccComposite.getValue("cfvu_mcc_validation_status", false, false);
	if (cfvuValidated)
	{
		mccComposite.setValue("cfvu_mcc_control_status", true);
		
		// Copy CFVU validation step to CFVU control step
		Repository.helper.setModelAwareValue(mccComposite, "cfvu_mcc_control_date", mccComposite.getValue("cfvu_mcc_validation_date"));
		Repository.helper.setModelAwareValue(mccComposite, "cfvu_mcc_control_author", mccComposite.getValue("cfvu_mcc_validation_author"));
		Repository.helper.setModelAwareValue(mccComposite, "cfvu_mcc_control_comment", mccComposite.getValue("cfvu_mcc_validation_comment", false, ""));
		
		hasChanges = true;
	}
}