<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:exsl="http://exslt.org/common">
    
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/utils.xsl"/>
    
    <xsl:template match="/report">
        <csv>
            <xsl:call-template name="header"/>
            
            <xsl:for-each select="course">
                <xsl:choose>
                    <xsl:when test="count(courseParts/coursePart) > 0">
                        <xsl:for-each select="courseParts/coursePart">
                            <xsl:call-template name="course">
                                <xsl:with-param name="currentCourse" select="../.."/>
                                <xsl:with-param name="currentCoursePart" select="/report/courseParts/coursePart[@id = current()/@id]"/>
                            </xsl:call-template>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="course">
                            <xsl:with-param name="currentCourse" select="."/>
                        </xsl:call-template>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </csv>
    </xsl:template>
    
    <xsl:template name="header">
        <row>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_ORDRE"/></cell>
            <!-- Formation -->
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_PROGRAM"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_COMPOSANTE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_PROGRAM"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_FORMATION"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_PROGRAM"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_FORMATION_CODE"/></cell>
            <!-- Parcours -->
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_SUBPROGRAM"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_PARCOURS"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_SUBPROGRAM"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_PARCOURS_CODE"/></cell>
            <!-- Etape -->
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_STEP"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_ANNEE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_STEP"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_ANNEE_CODE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_STEP"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_COD_ETP"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_STEP"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_COD_VRS_ETP"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_STEP"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_ANNEE_NB_STUDENTS"/></cell>
            <!-- Liste -->
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE_LIST"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_CODE_ELP_PERE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE_LIST"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_LISTE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE_LIST"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_TYPE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE_LIST"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_MIN"/></cell>
            <!-- ELP -->
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_A_DES_FILS"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_PARTAGE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_OCCURRENCE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_PORTE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_NIVEAU"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_CREATION_DATE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_CODE_ELP_APOGEE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_NATURE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_LIBELLE_COURT"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_LIBELLE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_CODE_ELP"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_LIEU"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_ECTS"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_ELEMENT_STAGE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_CODE_SEMESTRE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_CODE_TYPE_PERIODE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_CODE_COMPOSANTE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_CODE_CIP"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_CODE_ANU"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_CALCUL_DES_CHARGES"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_DISCIPLINE"/></cell>
            <!-- Heures d'enseignement -->
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE_PART"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_ENSEIGNEMENT_ELP_PORTEUR"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE_PART"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_ENSEIGNEMENT_TITRE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE_PART"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_ENSEIGNEMENT_CODE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE_PART"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_ENSEIGNEMENT_NATURE"/></cell>
            <!-- Calculs -->
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_CALCULS"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_VOLUME"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_CALCULS"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_EFFECTIFS_LOCAL"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_CALCULS"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_EFFECTIFS_PREV_CALC"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_CALCULS"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_EFFECTIFS_PREV"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_CALCULS"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_EFFECTIFS_MAX"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_CALCULS"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_EFFECTIFS_MIN_SUP"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_CALCULS"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_NORME"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_CALCULS"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_GROUPES_CALCULES"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_CALCULS"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_GROUPES_A_OUVRIR"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_CALCULS"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_EQ_TD_TOTAL"/></cell>
            <!-- Etape porteuse -->
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_ETAPE_PORTEUSE"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_ETAPE_PORTEUSE_CODE"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_ETAPE_PORTEUSE"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_ETAPE_PORTEUSE_CODE_ETP"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_ETAPE_PORTEUSE"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_ETAPE_PORTEUSE_CODE_VRS_ETP"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_ETAPE_PORTEUSE"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_ETAPE_PORTEUSE_TITLE"/></cell>
            <!-- Couts -->
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COUTS"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_EQTD_PRORATISEES"/></cell>
            <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COUTS"/> - <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_EQTD_PORTEES"/></cell>
            <!-- Ventilation des effectifs -->
            <xsl:for-each select="columns/column">
                <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_EFFECTIFS_VENTILES"/> - <xsl:value-of select="."/></cell>
            </xsl:for-each>
            <!-- Ventilation des eqTD -->
            <xsl:for-each select="columns/column">
                <cell><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_EQ_TD_VENTILES"/> - <xsl:value-of select="."/></cell>
            </xsl:for-each>
        </row>
    </xsl:template>
    
    <xsl:template name="course">
        <xsl:param name="currentCourse"/>
        <xsl:param name="currentCoursePart"/>
        
        <row>
            <cell><xsl:value-of select="$currentCourse/ordre"/></cell>
            
            <!-- Formation -->
            <xsl:choose>
                <xsl:when test="$currentCourse/program">
                    <cell><xsl:value-of select="$currentCourse/program/orgUnits"/></cell>
                    <cell><xsl:value-of select="$currentCourse/program/title"/></cell>
                    <cell><xsl:value-of select="$currentCourse/program/code"/></cell>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="empty-cells">
                        <xsl:with-param name="nbCells" select="3"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
            
            <!-- Parcours -->
            <xsl:choose>
                <xsl:when test="$currentCourse/subProgram">
                    <cell><xsl:value-of select="$currentCourse/subProgram/title"/></cell>
                    <cell><xsl:value-of select="$currentCourse/subProgram/code"/></cell>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="empty-cells">
                        <xsl:with-param name="nbCells" select="2"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
            
            <!-- Année -->
            <xsl:choose>
                <xsl:when test="$currentCourse/year">
                    <cell><xsl:value-of select="$currentCourse/year/title"/></cell>
                    <cell><xsl:value-of select="$currentCourse/year/code"/></cell>
                    <cell><xsl:value-of select="$currentCourse/year/COD_ETP"/></cell>
                    <cell><xsl:value-of select="$currentCourse/year/COD_VRS_ETP"/></cell>
                    <cell><xsl:value-of select="$currentCourse/year/nbStudents"/></cell>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="empty-cells">
                        <xsl:with-param name="nbCells" select="5"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
            
            <!-- ELP père -->
            <xsl:choose>
                <xsl:when test="$currentCourse/parentCourse">
                    <cell><xsl:value-of select="$currentCourse/parentCourse/codeELPPere"/></cell>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="empty-cells">
                        <xsl:with-param name="nbCells" select="1"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
            
            <!-- Liste -->
            <xsl:choose>
                <xsl:when test="$currentCourse/courseList">
                    <cell><xsl:value-of select="$currentCourse/courseList/@displayName"/></cell>
                    <cell><xsl:value-of select="$currentCourse/courseList/@type"/></cell>
                    <cell><xsl:value-of select="$currentCourse/courseList/@minmax"/></cell>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="empty-cells">
                        <xsl:with-param name="nbCells" select="3"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
            
            <cell><xsl:value-of select="$currentCourse/aDesFils"/></cell>
            
            <!-- Partage -->
            <xsl:choose>
                <xsl:when test="$currentCourse/partage">
                    <cell><xsl:text>X</xsl:text></cell>
                    <cell><xsl:value-of select="$currentCourse/partage/@occurrences"/></cell>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="empty-cells">
                        <xsl:with-param name="nbCells" select="2"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
            
            <!-- ELP -->
            <cell><xsl:value-of select="$currentCourse/porte"/></cell>
            <cell><xsl:value-of select="$currentCourse/niveau"/></cell>
            <cell><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="long"><xsl:value-of select="$currentCourse/creationDate"/></i18n:date></cell>
            <cell><xsl:value-of select="$currentCourse/codeApogee"/></cell>
            <cell><xsl:value-of select="$currentCourse/nature"/></cell>
            <cell><xsl:value-of select="$currentCourse/libelleCourt"/></cell>
            <cell><xsl:value-of select="$currentCourse/libelle"/></cell>
            <cell><xsl:value-of select="$currentCourse/elpCode"/></cell>
            <cell><xsl:value-of select="$currentCourse/campus"/></cell>
            <cell>
                <xsl:call-template name="display-double">
                    <xsl:with-param name="value"><xsl:value-of select="$currentCourse/ects"/></xsl:with-param>
                </xsl:call-template>
            </cell>
            <cell><xsl:value-of select="$currentCourse/stage"/></cell>
            <cell><xsl:value-of select="$currentCourse/periode"/></cell>
            <cell><xsl:value-of select="$currentCourse/periodeType"/></cell>
            <cell><xsl:value-of select="$currentCourse/orgUnit/codeComposante"/></cell>
            <cell><xsl:value-of select="$currentCourse/orgUnit/codeCIP"/></cell>
            <cell><xsl:value-of select="$currentCourse/CodeAnu"/></cell>
            <cell><xsl:value-of select="$currentCourse/calculCharges"/></cell>
            <cell><xsl:value-of select="$currentCourse/discipline"/></cell>
            
            <!-- Heure d'enseignement -->
            <xsl:choose>
                <xsl:when test="$currentCoursePart">
                    <cell><xsl:value-of select="$currentCoursePart/elpPorteur"/></cell>
                    <cell><xsl:value-of select="$currentCoursePart/titre"/></cell>
                    <cell><xsl:value-of select="$currentCoursePart/code"/></cell>
                    <cell><xsl:value-of select="$currentCoursePart/nature"/></cell>
                    
                    <!-- Calculs -->
                    <cell><xsl:value-of select="$currentCoursePart/volumeHoraire"/></cell>
                    <cell>
                        <!-- path = programName(/*)/subProgramName(/*)/yearName(/*)/parentCourseName(/*)/courseListName(/*)/courseName(/*) -->
                        <xsl:call-template name="display-double">
                            <xsl:with-param name="value"><xsl:value-of select="sum($currentCoursePart/effectif[@path = concat($currentCourse/@path, $currentCoursePart/@name)])"/></xsl:with-param>
                            <xsl:with-param name="showZero" select="true()" />
                        </xsl:call-template>
                    </cell>
                    <cell><xsl:value-of select="$currentCoursePart/effectifCalcule"/></cell>
                    <cell><xsl:value-of select="$currentCoursePart/effectifPrevisionnel"/></cell>
                    <cell><xsl:value-of select="$currentCoursePart/effectifMax"/></cell>
                    <cell><xsl:value-of select="$currentCoursePart/effectifMinSup"/></cell>
                    <cell><xsl:value-of select="$currentCoursePart/norme"/></cell>
                    <cell><xsl:value-of select="$currentCoursePart/groupesCalcules"/></cell>
                    <cell><xsl:value-of select="$currentCoursePart/groupesAOuvrir"/></cell>
                    <cell><xsl:value-of select="$currentCoursePart/eqTDTotal"/></cell>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="empty-cells">
                        <xsl:with-param name="nbCells" select="14"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
            
            <!-- Etape porteuse -->
            <xsl:choose>
                <xsl:when test="$currentCourse/stepHolder">
                    <cell><xsl:value-of select="$currentCourse/stepHolder/code"/></cell>
                    <cell><xsl:value-of select="$currentCourse/stepHolder/etpCode"/></cell>
                    <cell><xsl:value-of select="$currentCourse/stepHolder/vrsEtpCode"/></cell>
                    <cell><xsl:value-of select="$currentCourse/stepHolder/title"/></cell>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="empty-cells">
                        <xsl:with-param name="nbCells" select="4"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
            
            <!-- Couts et ventilation-->
            <xsl:choose>
                <xsl:when test="$currentCoursePart">
                    <cell>
                        <!-- path = programName(/*)/subProgramName(/*)/yearName(/*)/parentCourseName(/*)/courseListName(/*)/courseName(/*) -->
                        <xsl:call-template name="display-double">
                            <xsl:with-param name="value"><xsl:value-of select="sum($currentCoursePart/proratedEqTD[@path = concat($currentCourse/@path, $currentCoursePart/@name)])"/></xsl:with-param>
                            <xsl:with-param name="showZero" select="true()" />
                        </xsl:call-template>
                    </cell>
                    <cell>
                        <!-- path = programName(/*)/subProgramName(/*)/yearName(/*)/parentCourseName(/*)/courseListName(/*)/courseName(/*) -->
                        <xsl:call-template name="display-double">
                            <xsl:with-param name="value"><xsl:value-of select="sum($currentCoursePart/localEqTD[@path = concat($currentCourse/@path, $currentCoursePart/@name)])"/></xsl:with-param>
                            <xsl:with-param name="showZero" select="true()" />
                        </xsl:call-template>
                    </cell>
                    <!-- Effectifs ventilés -->
                    <xsl:for-each select="/report/columns/column">
                        <cell>
                            <!-- path = */containerName/* -->
                            <xsl:call-template name="display-double">
                                <xsl:with-param name="value"><xsl:value-of select="sum($currentCoursePart/effectif[contains(@path, concat('/', current()/@name, '/'))])"/></xsl:with-param>
                            </xsl:call-template>
                        </cell>
                    </xsl:for-each>
                    <!-- eqTD ventilés -->
                    <xsl:for-each select="/report/columns/column">
                        <cell>
                            <!-- path = */containerName/* -->
                            <xsl:call-template name="display-double">
                                <xsl:with-param name="value"><xsl:value-of select="sum($currentCoursePart/proratedEqTD[contains(@path, concat('/', current()/@name, '/'))])"/></xsl:with-param>
                            </xsl:call-template>
                        </cell>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="empty-cells">
                        <xsl:with-param name="nbCells" select="(count(/report/columns/column) * 2) + 2"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </row>
    </xsl:template>
        
    <xsl:template name="empty-cells">
        <xsl:param name="nbCells" select="0"/>
        
        <xsl:if test="$nbCells > 0">
            <cell/>
            <xsl:call-template name="empty-cells">
                <xsl:with-param name="nbCells" select="$nbCells - 1"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>
