<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/report/mcc2doc.xsl"/>
    
    <xsl:template name="css-styles">
        <xsl:call-template name="css-styles-mcc"/>
        <xsl:call-template name="css-styles-mccdiff"/>
    </xsl:template>
    
    <xsl:template name="css-styles-mccdiff">
        <!-- Added -->
        
        #<xsl:value-of select="$uniqueSectionId"/> table.main tbody tr td.session-cell-added
        {
            border-right: 0.5pt white solid;
            text-decoration: underline;
            color: green;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> table.main tbody tr td.session-cell-centered-added
        {
            border-right: 0.5pt white solid;
            text-align: center;
            text-decoration: underline;
            color: green;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> table.main tbody tr td.centered-added
        {
            text-align: center;
            text-decoration: underline;
            color: green;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> table.main tbody tr td.session-cell-added div.remarques
        {
            color: green !important;
        }
        
        <!-- Removed -->
        
        #<xsl:value-of select="$uniqueSectionId"/> table.main tbody tr td.session-cell-removed
        {
            border-right: 0.5pt white solid;
            text-decoration: line-through;
            color: red;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> table.main tbody tr td.session-cell-centered-removed
        {
            border-right: 0.5pt white solid;
            text-align: center;
            text-decoration: line-through;
            color: red;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> table.main tbody tr td.centered-removed
        {
            text-align: center;
            text-decoration: line-through;
            color: red;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> table.main tbody tr td.session-cell-removed div.remarques
        {
            color: red !important;
        }
        
        <!-- Modified old -->
        
        #<xsl:value-of select="$uniqueSectionId"/> table.main tbody tr td.session-cell-modified_old
        {
            border-right: 0.5pt white solid;
            text-decoration: line-through;
            border-bottom: 1px white solid !important;
            color: #cccccc;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> table.main tbody tr td.session-cell-centered-modified_old
        {
            border-right: 0.5pt white solid;
            text-align: center;
            text-decoration: line-through;
            border-bottom: 1px white solid !important;
            color: #cccccc;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> table.main tbody tr td.centered-modified_old
        {
            text-align: center;
            text-decoration: line-through;
            border-bottom: 1px white solid !important;
            color: #cccccc;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> table.main tbody tr td.session-cell-modified_old div.remarques
        {
            color: #cccccc !important;
        }
        
        <!-- Modified new -->
        
        #<xsl:value-of select="$uniqueSectionId"/> table.main tbody tr td.session-cell-modified_new
        {
            border-right: 0.5pt white solid;
            text-decoration: underline;
            color: blue;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> table.main tbody tr td.session-cell-centered-modified_new
        {
            border-right: 0.5pt white solid;
            text-align: center;
            text-decoration: underline;
            color: blue;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> table.main tbody tr td.centered-modified_new
        {
            text-align: center;
            text-decoration: underline;
            color: blue;
        }
        
        #<xsl:value-of select="$uniqueSectionId"/> table.main tbody tr td.session-cell-modified_new div.remarques
        {
            color: blue !important;
        }
    </xsl:template>
    
    <xsl:template name="catalog-title">
        <h2>
            <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_DIFF_HEADER_CATALOG"/>
            <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LABEL_VALUE_SEPARATOR"/>
            <xsl:apply-templates select="." mode="catalog"/>
        </h2>
        <h2>
            <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_DIFF_HEADER_CATALOG_OLD"/>
            <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LABEL_VALUE_SEPARATOR"/>
            <xsl:value-of select="/report/catalogOld"/>
        </h2>
    </xsl:template>
    
    <xsl:template match="entry" mode="suffix">
        <xsl:if test="@changeType != ''">-<xsl:value-of select="@changeType"/></xsl:if>
    </xsl:template>
</xsl:stylesheet>