<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:su="org.ametys.core.util.StringUtils"
                xmlns:exsl="http://exslt.org/common"
                exclude-result-prefixes="i18n exsl su">
    
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/utils.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/xls.xsl"/>
    
    <xsl:variable name="naturesEnseignement">
        <xsl:for-each select="/report/items[@id = 'odf-enumeration.EnseignementNature']/category/item">
            <xsl:sort select="../@order" data-type="number"/>
            <xsl:sort select="../@code" data-type="text"/>
            <xsl:sort select="@order" data-type="number"/>
            <xsl:sort select="@code" data-type="text"/>
            <xsl:if test="@archived = 'false' or //volume[@id = current()/@id]">
                <item id="{@id}" code="{@code}"><xsl:value-of select="."/></item>
            </xsl:if>
        </xsl:for-each>
    </xsl:variable>
    
    <xsl:template name="style">
        <xsl:param name = "type" />
        <xsl:if test="$type != 'container'">
            <xsl:attribute name="class"><xsl:value-of select="$type"/></xsl:attribute>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="css-styles">
        table
        {
            width: 100%;
            padding: 0px;
            margin: 0px;
            border-spacing: 0;
            border-collapse: collapse;
            font-size: 10pt;
        }
        
        .styled
        {
            vertical-align: middle;
            font-weight: bold;
            text-align: center;
            background-color: darkblue;
            border: 0.5pt white solid;
            color: white;
        }
        
        table tbody tr.program td,
        table tbody tr.orgunit td
        {
            padding: 6px 1px 2px;
            border-bottom: 0.5pt #cccccc solid;
            color: darkblue;
            font-weight: bold;
        }
        
        td
        {
            padding: 2pt;
            vertical-align: middle;
        }
    </xsl:template>
   
    <xsl:template name="table-head">
        <tr>
            <th colspan="2"></th>
            <th colspan="{count(exsl:node-set($naturesEnseignement)/*) + 1}" class="styled"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_SYNTHESIS_TITLE_VOLUMES_HORAIRES"/></th>
            <th colspan="4"></th>
        </tr>
        <tr class="styled">
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_SYNTHESIS_TITLE_DIPLOME"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_SYNTHESIS_TITLE_ANNEE"/></th>
            <!--Volumes horaires -->
            <xsl:for-each select="exsl:node-set($naturesEnseignement)/*">
                <th><xsl:value-of select="@code"/></th>
            </xsl:for-each>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_SYNTHESIS_TITLE_TOTAL"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_SYNTHESIS_TITLE_EqTD"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_SYNTHESIS_TITLE_EqTDNET"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_SYNTHESIS_TITLE_EFFECTIFS"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_SYNTHESIS_TITLE_RAPPORT"/></th>
        </tr>
    </xsl:template>
   
    <xsl:template name="table-body">
        <xsl:for-each select="lines/line">
            <tr>
                <xsl:call-template name="style">
                    <xsl:with-param name="type" select="type" />
                </xsl:call-template>
                
                <td><xsl:value-of select="su:sanitizeXlsHtml(diplome)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(annee)"/></td>
                
                <!--  Volumes horaires -->
                <xsl:variable name="currentLine" select="."/>
                <xsl:for-each select="exsl:node-set($naturesEnseignement)/*">
                    <td>
                        <xsl:call-template name="display-double">
                            <xsl:with-param name="value" select="$currentLine/volume[@id = current()/@id]" />
                            <xsl:with-param name="showZero" select="true()" />
                        </xsl:call-template>
                    </td>
                </xsl:for-each>
                
                <td>
                    <xsl:call-template name="display-double">
                        <xsl:with-param name="value" select="total" />
                        <xsl:with-param name="showZero" select="true()" />
                    </xsl:call-template>
                </td>
                <td>
                    <xsl:call-template name="display-double">
                        <xsl:with-param name="value" select="eqtdLocal" />
                        <xsl:with-param name="showZero" select="true()" />
                    </xsl:call-template>
                </td>
                <td>
                    <xsl:call-template name="display-double">
                        <xsl:with-param name="value" select="eqtdProrated" />
                        <xsl:with-param name="showZero" select="true()" />
                    </xsl:call-template>
                </td>
                <td><xsl:value-of select="effectif"/></td>
                <td>
                    <xsl:call-template name="display-double">
                        <xsl:with-param name="value" select="heRatio" />
                        <xsl:with-param name="showZero" select="true()" />
                    </xsl:call-template>
                </td>
            </tr>
        </xsl:for-each>
    </xsl:template>
</xsl:stylesheet>
