/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.validator;

import java.util.Arrays;
import java.util.Map;
import org.ametys.cms.contenttype.AttributeDefinition;
import org.ametys.cms.contenttype.ContentAttributeDefinition;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.contenttype.validation.AbstractContentValidator;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.data.holder.group.IndexableRepeater;
import org.ametys.cms.data.holder.group.IndexableRepeaterEntry;
import org.ametys.cms.model.ContentRestrictedRepeaterDefinition;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.odfpilotage.helper.PilotageHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.disableconditions.DefaultDisableConditionsEvaluator;
import org.ametys.runtime.model.disableconditions.DisableConditionsEvaluator;
import org.ametys.runtime.parameter.ValidationResult;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.codec.binary.StringUtils;

public class CourseMccRegimeValidator
extends AbstractContentValidator
implements Serviceable {
    private ContentTypesHelper _contentTypesHelper;
    private DisableConditionsEvaluator _disableConditionsEvaluator;
    private PilotageHelper _pilotageHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._contentTypesHelper = (ContentTypesHelper)manager.lookup(ContentTypesHelper.ROLE);
        this._disableConditionsEvaluator = (DisableConditionsEvaluator)manager.lookup(DefaultDisableConditionsEvaluator.ROLE);
        this._pilotageHelper = (PilotageHelper)((Object)manager.lookup(PilotageHelper.ROLE));
    }

    public ValidationResult validate(Content content) {
        Content mccRegimeContent;
        ContentValue mccRegime;
        ValidationResult result = new ValidationResult();
        AttributeDefinition mccRegimeDefinition = (AttributeDefinition)content.getDefinition("mccRegime");
        if (!this._disableConditionsEvaluator.evaluateDisableConditions((ModelItem)mccRegimeDefinition, "mccRegime", (Object)content) && (mccRegime = (ContentValue)content.getValue("mccRegime")) != null && mccRegime.getContentId() != null && (mccRegimeContent = (Content)mccRegime.getContentIfExists().orElse(null)) != null) {
            result.addResult(this._check(mccRegimeContent.getId(), content, "mccSession1"));
            result.addResult(this._check(mccRegimeContent.getId(), content, "mccSession2"));
        }
        return result;
    }

    private ValidationResult _check(String mccRegimeId, Content content, String mccSession) {
        IndexableRepeater repeater;
        ValidationResult result = new ValidationResult();
        ContentRestrictedRepeaterDefinition mccSessionDefinition = (ContentRestrictedRepeaterDefinition)content.getDefinition(mccSession);
        if (!this._disableConditionsEvaluator.evaluateDisableConditions((ModelItem)mccSessionDefinition, mccSession, (Object)content) && this._pilotageHelper.canWriteMccRestrictions(content, mccSession) && (repeater = content.getRepeater(mccSession)) != null) {
            int index = 0;
            for (IndexableRepeaterEntry entry : repeater.getEntries()) {
                ValidationResult localResult;
                ++index;
                ContentValue modalite = (ContentValue)entry.getValue("modalite");
                if (modalite == null || modalite.getContentId() == null) continue;
                ContentAttributeDefinition mccSessionModaliteDefinition = (ContentAttributeDefinition)content.getDefinition(mccSession + "/modalite");
                Content modaliteContent = modalite.getContentIfExists().orElse(null);
                if (modaliteContent != null) {
                    if (!this._contentTypesHelper.isInstanceOf(modaliteContent, mccSessionModaliteDefinition.getContentTypeId())) {
                        result.addError(new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_COURSE_MCCREGIME_VALIDATOR_ERROR_1", Map.of("fieldSession", content.getDefinition(mccSession).getLabel(), "fieldSessionPosition", new I18nizableText(Integer.toString(index)), "fieldModalite", mccSessionModaliteDefinition.getLabel())));
                        continue;
                    }
                    ContentValue[] regimes = (ContentValue[])modaliteContent.getValue("compatibleRegimes");
                    if (regimes == null || regimes.length <= 0 || Arrays.stream(regimes).map(ContentValue::getContentId).anyMatch(c -> StringUtils.equals((CharSequence)mccRegimeId, (CharSequence)c))) continue;
                    result.addError(new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_COURSE_MCCREGIME_VALIDATOR_ERROR_2", Map.of("fieldSession", content.getDefinition(mccSession).getLabel(), "fieldSessionPosition", new I18nizableText(Integer.toString(index)), "fieldModalite", mccSessionModaliteDefinition.getLabel())));
                    continue;
                }
                if (mccSessionModaliteDefinition.getValidator() == null || !(localResult = mccSessionModaliteDefinition.getValidator().validate(null)).hasErrors()) continue;
                result.addError(new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_COURSE_MCCREGIME_VALIDATOR_ERROR_3", Map.of("fieldSession", content.getDefinition(mccSession).getLabel(), "fieldSessionPosition", new I18nizableText(Integer.toString(index)), "fieldModalite", mccSessionModaliteDefinition.getLabel())));
            }
        }
        return result;
    }

    public ValidationResult validate(Content content, Map<String, Object> values, View view) {
        return ValidationResult.empty();
    }
}

