/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.rule.export;

import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.catalog.CatalogsManager;
import org.ametys.plugins.odfpilotage.rule.export.AbstractSetContentDispositionHeaderAction;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.environment.Request;

public class SetMCCHeaderAction
extends AbstractSetContentDispositionHeaderAction
implements Serviceable {
    public static final Map<String, String> VERSION_TO_SUFFIX = Map.of("final", "", "work", "-complet", "diff", "-modifications");
    protected CatalogsManager _catalogsManager;
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._catalogsManager = (CatalogsManager)serviceManager.lookup(CatalogsManager.ROLE);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
    }

    @Override
    protected String buildFilename(Request request, Parameters parameters) throws Exception {
        String programItemId = request.getParameter("programItem");
        ProgramItem programItem = (ProgramItem)this._resolver.resolveById(programItemId);
        String version = parameters.getParameter("version");
        String format = parameters.getParameter("format");
        String prefix = parameters.getParameter("prefix", "");
        StringBuilder filename = new StringBuilder();
        filename.append(prefix);
        filename.append(this._catalogsManager.getCatalog(programItem.getCatalog()).getTitle());
        filename.append("-");
        filename.append(((Content)programItem).getTitle());
        filename.append("-");
        filename.append(programItem.getCode());
        filename.append(VERSION_TO_SUFFIX.getOrDefault(version, "-" + version));
        filename.append(".");
        filename.append(format);
        return filename.toString();
    }
}

