/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.report.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.ametys.cms.content.compare.ContentComparator;
import org.ametys.cms.content.compare.ContentComparatorResult;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.coursepart.CoursePart;
import org.ametys.odf.program.Container;
import org.ametys.plugins.odfpilotage.report.impl.AbstractMaquetteExtract;
import org.ametys.plugins.odfpilotage.report.impl.tree.ProgramItemTree;
import org.ametys.plugins.odfpilotage.schedulable.AbstractReportSchedulable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItemAccessor;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MaquetteDiffExtract
extends AbstractMaquetteExtract {
    public static final String PARAMETER_CATALOG_OLD = "catalogOld";
    protected View _courseCompareView;
    private ContentComparator _contentComparator;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._contentComparator = (ContentComparator)manager.lookup(ContentComparator.ROLE);
    }

    @Override
    public void initialize() throws Exception {
        super.initialize();
        this._courseCompareView = this.getView("org.ametys.plugins.odf.Content.course", "report-maquette-compare");
    }

    @Override
    public String getType(Map<String, String> reportParameters, boolean shortName) {
        return "maquettediff";
    }

    @Override
    protected boolean isGeneric() {
        return false;
    }

    @Override
    protected boolean isCompatibleSchedulable(AbstractReportSchedulable schedulable) {
        return schedulable.getId().equals("org.ametys.plugins.odfpilotage.schedulable.OrgUnitDiffReportSchedulable");
    }

    @Override
    protected ProgramItemTree createTreeFromProgramItem(ProgramItem programItem, Map<String, String> reportParameters) {
        ProgramItem oldProgramItem = this._findOldProgramItem(programItem, reportParameters.get(PARAMETER_CATALOG_OLD));
        ContentComparatorResult changes = this._getObjectChanges(oldProgramItem, programItem);
        ProgramItemTree programItemTree = new ProgramItemTree(programItem, changes);
        this.populateTree(programItemTree);
        return programItemTree;
    }

    @Override
    protected void populateTree(ProgramItemTree tree) {
        ProgramItem oldProgramItem = (ProgramItem)tree.getChange().getContent1();
        ProgramItem newProgramItem = (ProgramItem)tree.getChange().getContent2();
        if (oldProgramItem == null) {
            List<ProgramItem> children = this.getOrderedChildren(newProgramItem);
            for (ProgramItem child : children) {
                ContentComparatorResult changes = this._getObjectChanges(null, child);
                ProgramItemTree childTree = tree.addChild(child, changes);
                this.populateTree(childTree);
            }
        } else if (newProgramItem == null) {
            List<ProgramItem> children = this.getOrderedChildren(oldProgramItem);
            for (ProgramItem child : children) {
                ContentComparatorResult changes = this._getObjectChanges(child, null);
                ProgramItemTree childTree = tree.addChild(child, changes);
                this.populateTree(childTree);
            }
        } else {
            List<ProgramItem> oldChildren = this.getOrderedChildren(oldProgramItem);
            List<ProgramItem> newChildren = this.getOrderedChildren(newProgramItem);
            for (ProgramItem newChild : newChildren) {
                ProgramItem currentOldChild = null;
                Class newChildClass = newChild.getClass();
                String newChildCode = newChild.getCode();
                for (ProgramItem oldChild : oldChildren) {
                    if (!oldChild.getCode().equals(newChildCode) || !oldChild.getClass().equals(newChildClass)) continue;
                    currentOldChild = oldChild;
                    oldChildren.remove(oldChild);
                    break;
                }
                ContentComparatorResult changes = this._getObjectChanges(currentOldChild, newChild);
                ProgramItemTree childTree = tree.addChild(newChild, changes);
                this.populateTree(childTree);
            }
            for (ProgramItem oldChild : oldChildren) {
                ContentComparatorResult changes = this._getObjectChanges(oldChild, null);
                ProgramItemTree childTree = tree.addChild(oldChild, changes);
                this.populateTree(childTree);
            }
        }
    }

    @Override
    protected void saxContent(ContentHandler handler, String tagName, Content content, View view, ProgramItemTree tree, boolean saxHierarchy) throws SAXException {
        ContentComparatorResult changes = tree.getChange();
        if (!changes.areEquals() && changes.getContent1() != null && changes.getContent2() != null) {
            super.saxContent(handler, tagName, changes.getContent1(), view, tree, false);
        }
        super.saxContent(handler, tagName, content, view, tree, true);
    }

    @Override
    protected AttributesImpl getProgramItemAttributes(ProgramItem programItem, ProgramItemTree tree) {
        AttributesImpl attr = super.getProgramItemAttributes(programItem, tree);
        ContentComparatorResult changes = tree.getChange();
        if (!changes.areEquals()) {
            ProgramItemTree.ChangeType changeType = changes.getContent1() == null ? ProgramItemTree.ChangeType.ADDED : (changes.getContent2() == null ? ProgramItemTree.ChangeType.REMOVED : (changes.getContent1().equals((Object)programItem) ? ProgramItemTree.ChangeType.MODIFIED_OLD : ProgramItemTree.ChangeType.MODIFIED_NEW));
            attr.addCDATAAttribute("changeType", changeType.name().toLowerCase());
        }
        return attr;
    }

    private ContentComparatorResult _getObjectChanges(ProgramItem oldProgramItem, ProgramItem newProgramItem) {
        Content oldContent = (Content)oldProgramItem;
        Content newContent = (Content)newProgramItem;
        ContentComparatorResult changes = new ContentComparatorResult((ModelAwareDataHolder)oldContent, (ModelAwareDataHolder)newContent);
        if (changes.areEquals() && !this._equalsProgramItem(oldContent, newContent)) {
            changes.setNotEquals();
        }
        return changes;
    }

    private boolean _equalsProgramItem(Content oldProgramItem, Content newProgramItem) {
        try {
            ContentComparatorResult programItemChanges = this._contentComparator.compare((ModelAwareDataHolder)oldProgramItem, (ModelAwareDataHolder)newProgramItem, (ViewItemAccessor)this._courseCompareView);
            if (programItemChanges.areEquals() && oldProgramItem instanceof Course) {
                Course oldCourse = (Course)oldProgramItem;
                if (newProgramItem instanceof Course) {
                    Course newCourse = (Course)newProgramItem;
                    return this._equalsCourse(oldCourse, newCourse);
                }
            }
            return programItemChanges.areEquals();
        }
        catch (AmetysRepositoryException e) {
            this.getLogger().error("Une erreur est survenue pour l'ELP {} - {}", new Object[]{oldProgramItem.getValue("code"), newProgramItem.getTitle(), e});
            return true;
        }
    }

    private boolean _equalsCourse(Course oldCourse, Course newCourse) {
        return Objects.equals(oldCourse.getParentCourseLists().size(), newCourse.getParentCourseLists().size()) && Objects.equals(this._getContainerEtape(oldCourse), this._getContainerEtape(newCourse)) && Objects.equals(this._countNbHoursByNature(oldCourse), this._countNbHoursByNature(newCourse));
    }

    private Container _getContainerEtape(Course course) {
        return Optional.ofNullable((ContentValue)course.getValue("etapePorteuse")).flatMap(ContentValue::getContentIfExists).map(Container.class::cast).orElse(null);
    }

    private Map<String, Double> _countNbHoursByNature(Course course) {
        HashMap<String, Double> nbHours = new HashMap<String, Double>();
        for (CoursePart coursePart : course.getCourseParts()) {
            String nature = Optional.of((ContentValue)coursePart.getValue("nature")).map(ContentValue::getContentId).orElse("");
            nbHours.put(nature, nbHours.getOrDefault(nature, 0.0) + coursePart.getNumberOfHours());
        }
        return nbHours;
    }

    @Override
    protected void saxGlobalInformations(ContentHandler handler, ProgramItem programItem, Map<String, String> reportParameters) throws SAXException {
        super.saxGlobalInformations(handler, programItem, reportParameters);
        String oldCatalog = reportParameters.get(PARAMETER_CATALOG_OLD);
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", oldCatalog);
        XMLUtils.createElement((ContentHandler)handler, (String)PARAMETER_CATALOG_OLD, (Attributes)attrs, (String)this._catalogsManager.getCatalog(oldCatalog).getTitle());
    }

    private <T extends ProgramItem> T _findOldProgramItem(T content, String oldCatalog) {
        return (T)this._odfHelper.getProgramItem(content, oldCatalog, content.getLanguage());
    }
}

