<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/report/maquette2xls.xsl"/>
    
    <xsl:template name="css-styles">
        <xsl:call-template name="css-styles-maquette"/>
        <xsl:call-template name="css-styles-maquettediff"/>
    </xsl:template>
    
    <xsl:template name="css-styles-maquettediff">
        <!-- Added -->
        .h1-added,
        .h2-added,
        .h3-added,
        .h4-added,
        .choisirElement-added td,
        .course-added,
        .border-added,
        .codeAmetys-added,
        .codeEtapePorteuse-added
        {
            text-decoration: underline;
            color: green !important;
        }
        
        .h3-added
        {
            text-align: center;
            font-weight: bold;
            font-size: 13.5pt;
        }
        
        .h4-added
        {
            font-size: 12pt;
            font-weight: bold;
            color: darkblue;
        }
        
        .border-added
        { 
            border-left:0.5pt solid  #333333;
            text-align:center;
        }
        
        .codeEtapePorteuse-added
        { 
            border-left:0.5pt solid  #333333;
            text-align:left;
        }
        
        <!-- Modified new -->
        .h1-modified_new,
        .h2-modified_new,
        .h3-modified_new,
        .h4-modified_new,
        .choisirElement-modified_new td,
        .course-modified_new,
        .border-modified_new,
        .codeAmetys-modified_new,
        .codeEtapePorteuse-modified_new
        {
            text-decoration: underline;
            color: blue !important;
        }
        
        .h3-modified_new
        {
            text-align: center;
            font-weight: bold;
            font-size: 13.5pt;
        }
        
        .h4-modified_new
        {
            font-size: 12pt;
            font-weight: bold;
            color: darkblue;
        }
        
        .border-modified_new
        { 
            border-left:0.5pt solid  #333333;
            text-align:center;
        }
        
        .codeEtapePorteuse-modified_new
        { 
            border-left:0.5pt solid  #333333;
            text-align:left;
        }
        
        <!-- Removed -->
        .h1-removed,
        .h2-removed,
        .h3-removed,
        .h4-removed,
        .choisirElement-removed td,
        .course-removed,
        .border-removed,
        .codeAmetys-removed,
        .codeEtapePorteuse-removed
        {
            text-decoration: line-through;
            color: red !important;
        }
        
        .h3-removed
        {
            text-align: center;
            font-weight: bold;
            font-size: 13.5pt;
        }
        
        .h4-removed
        {
            font-size: 12pt;
            font-weight: bold;
            color: darkblue;
        }
        
        .border-removed
        { 
            border-left:0.5pt solid  #333333;
            text-align:center;
        }
        
        .codeEtapePorteuse-removed
        { 
            border-left:0.5pt solid  #333333;
            text-align:left;
        }
        
        <!-- Modified old -->
        .h1-modified_old,
        .h2-modified_old,
        .h3-modified_old,
        .h4-modified_old,
        .choisirElement-modified_old td,
        .course-modified_old,
        .border-modified_old,
        .codeAmetys-modified_old,
        .codeEtapePorteuse-modified_old
        {
            text-decoration: line-through;
            color: #cccccc !important;
            border-bottom: 0pt !important;
        }
        
        .h3-modified_old
        {
            text-align: center;
            font-weight: bold;
            font-size: 13.5pt;
        }
        
        .h4-modified_old
        {
            font-size: 12pt;
            font-weight: bold;
            color: darkblue;
        }
        
        .border-modified_old
        { 
            border-left:0.5pt solid  #333333;
            text-align:center;
        }
        
        .codeEtapePorteuse-modified_old
        { 
            border-left:0.5pt solid  #333333;
            text-align:left;
        }
    </xsl:template>
    
    <xsl:template match="program|subProgram|container|courseList|course" mode="suffix">
        <xsl:if test="@changeType != ''">-<xsl:value-of select="@changeType"/></xsl:if>
    </xsl:template>
</xsl:stylesheet>