<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:exsl="http://exslt.org/common"
                              exclude-result-prefixes="exsl">
                              
    <xsl:template name="legende">
        <tr/>
        <tr>
            <td class="legend-title" colspan="{$nbColumns}">
                <strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGENDE"/></strong>
            </td>
        </tr>
        <tr/>
        <xsl:call-template name="legende-titles"/>
        <xsl:call-template name="legende-enseignement-nature"/>
        <xsl:apply-templates select="exsl:node-set($referenceTables)/items" mode="legende"/>
    </xsl:template>
    
    <xsl:template name="legende-titles">
        <tr class="legend">
            <td colspan="{$nbColumns}">
                <p><strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_COLUMN_TITLES"/></strong></p>
                <ul>
                    <li>
                        <strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_EVALUATED"/></strong>
                        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_SEPARATOR"/>
                        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_EVALUATED"/>
                    </li>
                    <li>
                        <strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_NATURE"/></strong>
                        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_SEPARATOR"/>
                        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_NATURE"/>
                    </li>
                    <li>
                        <strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_SHARED"/></strong>
                        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_SEPARATOR"/>
                        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_SHARED"/>
                    </li>
                    <li>
                        <strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_COEF"/></strong>
                        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_SEPARATOR"/>
                        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_COEF"/>
                    </li>
                    <li>
                        <strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_NOTE_ELIM"/></strong>
                        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_SEPARATOR"/>
                        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_NOTE_ELIM"/>
                    </li>
                    <li>
                        <strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_NB_NOTES"/></strong>
                        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_SEPARATOR"/>
                        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_NB_NOTES"/>
                    </li>
                    <li>
                        <strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_PONDERATION"/></strong>
                        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_SEPARATOR"/>
                        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_PONDERATION"/>
                    </li>
                    <li>
                        <strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_REPORT_SESSION_2"/></strong>
                        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_SEPARATOR"/>
                        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_REPORT_SESSION_2"/>
                    </li>
                </ul>
            </td>
        </tr>
    </xsl:template>
    
    <xsl:template name="legende-enseignement-nature">
        <xsl:if test="count(exsl:node-set($naturesEnseignement)/*) > 0">
            <tr class="legend">
                <td colspan="{$nbColumns}">
                    <p><strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_TITLE_ENSEIGNEMENT_NATURE"/></strong></p>
                    <ul>
                        <xsl:for-each select="exsl:node-set($naturesEnseignement)/*">
                            <li>
                                <strong>
                                    <xsl:call-template name="displayCodeOrShortLabel">
                                        <xsl:with-param name="contentId" select="@id"/>
                                    </xsl:call-template>
                                </strong>
                                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_SEPARATOR"/>
                                <xsl:value-of select="."/>
                            </li>
                        </xsl:for-each>
                    </ul>
                </td>
            </tr>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="items" mode="legende">
        <!-- Display the legend items which are referenced in the report -->
        <xsl:variable name="items">
            <xsl:for-each select="item">
                <xsl:variable name="currentId" select="@id"/>
                <xsl:if test="$root//*[@id = $currentId and local-name() != 'item']">
                    <xsl:copy-of select="."/>
                </xsl:if>
            </xsl:for-each>
        </xsl:variable>
        
        <!-- Display the legend only if at least one item has to be displayed -->
        <xsl:if test="count(exsl:node-set($items)/item) > 0">
            <tr class="legend">
                <td colspan="{$nbColumns}">
                    <p><strong><xsl:apply-templates select="." mode="legende-title"/></strong></p>
                    <ul>
                        <xsl:for-each select="exsl:node-set($items)/item">
                            <xsl:sort select="@order" data-type="number"/>
                            <xsl:sort select="@code"/>
                            <li>
                                <strong>
                                    <xsl:call-template name="displayCodeOrShortLabel">
                                        <xsl:with-param name="contentId" select="@id"/>
                                    </xsl:call-template>
                                </strong>
                                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_SEPARATOR"/>
                                <xsl:value-of select="@title"/>
                            </li>
                        </xsl:for-each>
                    </ul>
                </td>
            </tr>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="items[@id = 'odf-enumeration.CourseNature']" mode="legende-title">
        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_TITLE_COURSE_NATURE"/>
    </xsl:template>
    
    <xsl:template match="items[@id = 'odf-enumeration.MccRegime']" mode="legende-title">
        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_TITLE_REGIME"/>
    </xsl:template>
    
    <xsl:template match="items[@id = 'odf-enumeration.MccModaliteSession1']" mode="legende-title">
        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_TITLE_SESSION_MODALITE_1"/>
    </xsl:template>
    
    <xsl:template match="items[@id = 'odf-enumeration.MccModaliteSession2']" mode="legende-title">
        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_TITLE_SESSION_MODALITE_2"/>
    </xsl:template>
    
    <xsl:template match="items[@id = 'odf-enumeration.MccSessionNature']" mode="legende-title">
        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LEGEND_TITLE_SESSION_NATURE"/>
    </xsl:template>
</xsl:stylesheet>
