/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.core.util.JSONUtils;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class PilotageMCCSessionsTemplateHelper
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = PilotageMCCSessionsTemplateHelper.class.getName();
    private static final String __MCC_SESSIONS_TEMPLATES_USER_PREF_CONTEXT = "/mcc-sessions-templates";
    private static final String __MCC_SESSIONS_TEMPLATES_USER_PREF_ID = "mcc-sessions";
    protected CurrentUserProvider _currentUserProvider;
    protected UserPreferencesManager _userPrefManager;
    protected JSONUtils _jsonUtils;

    public void service(ServiceManager manager) throws ServiceException {
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._userPrefManager = (UserPreferencesManager)manager.lookup(UserPreferencesManager.ROLE);
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
    }

    @Callable(rights={"*"})
    public Map<String, Object> createMCCSessionsTemplate(String templateName, List<Object> mccSessions) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        UserIdentity user = this._currentUserProvider.getUser();
        try {
            String sessionsAsJSON = this._userPrefManager.getUserPreferenceAsString(user, __MCC_SESSIONS_TEMPLATES_USER_PREF_CONTEXT, Map.of(), __MCC_SESSIONS_TEMPLATES_USER_PREF_ID);
            this._userPrefManager.addUserPreference(user, __MCC_SESSIONS_TEMPLATES_USER_PREF_CONTEXT, Map.of(), __MCC_SESSIONS_TEMPLATES_USER_PREF_ID, this._addSessions(sessionsAsJSON, templateName, mccSessions));
        }
        catch (UserPreferencesException e) {
            this.getLogger().error("An error occurred setting user preferences for MCC sessions template name '{}'", (Object)templateName, (Object)e);
            results.put("error", true);
        }
        return results;
    }

    @Callable(rights={"*"})
    public Map<String, Object> getUserMCCSessionsTemplates(Map<String, Object> parameters) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        UserIdentity user = this._currentUserProvider.getUser();
        try {
            String templateUserPrefAsString = this._userPrefManager.getUserPreferenceAsString(user, __MCC_SESSIONS_TEMPLATES_USER_PREF_CONTEXT, Map.of(), __MCC_SESSIONS_TEMPLATES_USER_PREF_ID);
            Map templateUserPrefs = this._jsonUtils.convertJsonToMap(templateUserPrefAsString);
            List<Map> templates = templateUserPrefs.keySet().stream().map(t -> Map.of("title", t)).toList();
            results.put("templates", templates);
        }
        catch (UserPreferencesException e) {
            this.getLogger().error("An error occurred getting user preferences for MCC sessions", (Throwable)e);
            results.put("error", true);
        }
        return results;
    }

    @Callable(rights={"*"})
    public Map<String, Object> deleteMCCSessionsTemplate(String templateName) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        UserIdentity user = this._currentUserProvider.getUser();
        try {
            String sessionsAsJSON = this._userPrefManager.getUserPreferenceAsString(user, __MCC_SESSIONS_TEMPLATES_USER_PREF_CONTEXT, Map.of(), __MCC_SESSIONS_TEMPLATES_USER_PREF_ID);
            this._userPrefManager.addUserPreference(user, __MCC_SESSIONS_TEMPLATES_USER_PREF_CONTEXT, Map.of(), __MCC_SESSIONS_TEMPLATES_USER_PREF_ID, this._deleteSessions(sessionsAsJSON, templateName));
        }
        catch (UserPreferencesException e) {
            this.getLogger().error("An error occurred deleting user preferences for MCC sessions template name '{}'", (Object)templateName, (Object)e);
            results.put("error", true);
        }
        return results;
    }

    @Callable(rights={"*"})
    public Map<String, Object> renameMCCSessionsTemplate(String oldTemplateName, String newTemplateName) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        UserIdentity user = this._currentUserProvider.getUser();
        try {
            String sessionsAsJSON = this._userPrefManager.getUserPreferenceAsString(user, __MCC_SESSIONS_TEMPLATES_USER_PREF_CONTEXT, Map.of(), __MCC_SESSIONS_TEMPLATES_USER_PREF_ID);
            this._userPrefManager.addUserPreference(user, __MCC_SESSIONS_TEMPLATES_USER_PREF_CONTEXT, Map.of(), __MCC_SESSIONS_TEMPLATES_USER_PREF_ID, this._renameSessions(sessionsAsJSON, oldTemplateName, newTemplateName));
        }
        catch (UserPreferencesException e) {
            this.getLogger().error("An error occurred renaming user preferences for MCC sessions template name '{}'", (Object)oldTemplateName, (Object)e);
            results.put("error", true);
        }
        return results;
    }

    @Callable(rights={"*"})
    public Map<String, Object> getMCCSessionsTemplate(String templateName) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        UserIdentity user = this._currentUserProvider.getUser();
        try {
            String sessionsAsJSON = this._userPrefManager.getUserPreferenceAsString(user, __MCC_SESSIONS_TEMPLATES_USER_PREF_CONTEXT, Map.of(), __MCC_SESSIONS_TEMPLATES_USER_PREF_ID);
            Map allSessions = this._jsonUtils.convertJsonToMap(sessionsAsJSON);
            results.put("sessions", allSessions.get(templateName));
        }
        catch (UserPreferencesException e) {
            this.getLogger().error("An error occurred getting user preferences for MCC sessions template name '{}'", (Object)templateName, (Object)e);
            results.put("error", true);
        }
        return results;
    }

    private String _addSessions(String allSessionsAsJSON, String templateName, List<Object> mccSessions) {
        Map allSessions = this._jsonUtils.convertJsonToMap(allSessionsAsJSON);
        allSessions.put(templateName, mccSessions);
        return this._jsonUtils.convertObjectToJson((Object)allSessions);
    }

    private String _renameSessions(String allSessionsAsJSON, String oldTemplateName, String newTemplateName) {
        Map allSessions = this._jsonUtils.convertJsonToMap(allSessionsAsJSON);
        allSessions.put(newTemplateName, allSessions.get(oldTemplateName));
        allSessions.remove(oldTemplateName);
        return this._jsonUtils.convertObjectToJson((Object)allSessions);
    }

    private String _deleteSessions(String allSessionsAsJSON, String templateName) {
        Map allSessions = this._jsonUtils.convertJsonToMap(allSessionsAsJSON);
        allSessions.remove(templateName);
        return this._jsonUtils.convertObjectToJson((Object)allSessions);
    }
}

