/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.rule.validators;

import java.util.HashMap;
import java.util.Map;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.contenttype.validation.AbstractContentValidator;
import org.ametys.cms.languages.LanguagesManager;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.cms.repository.LanguageExpression;
import org.ametys.odf.catalog.CatalogsManager;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.data.holder.values.SynchronizableValue;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.View;
import org.ametys.runtime.parameter.ValidationResult;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class UnicityValidator
extends AbstractContentValidator
implements Serviceable {
    protected AmetysObjectResolver _resolver;
    protected ContentTypesHelper _contentTypeHelper;
    protected CatalogsManager _catalogsManager;
    protected LanguagesManager _languagesManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._contentTypeHelper = (ContentTypesHelper)manager.lookup(ContentTypesHelper.ROLE);
        this._catalogsManager = (CatalogsManager)manager.lookup(CatalogsManager.ROLE);
        this._languagesManager = (LanguagesManager)manager.lookup(LanguagesManager.ROLE);
    }

    public ValidationResult validate(Content content) {
        return ValidationResult.empty();
    }

    public ValidationResult validate(Content content, Map<String, Object> values, View view) {
        ValidationResult result = new ValidationResult();
        if (values.containsKey("catalog")) {
            AndExpression expression;
            String query;
            String oldCatalog = (String)content.getValue("catalog");
            String newCatalog = (String)((SynchronizableValue)values.get("catalog")).getLocalValue();
            if (!newCatalog.equals(oldCatalog) && this._resolver.query(query = ContentQueryHelper.getContentXPathQuery((Expression)(expression = new AndExpression(new Expression[]{new ContentTypeExpression(Expression.Operator.EQ, content.getTypes()), new LanguageExpression(Expression.Operator.EQ, content.getLanguage()), new StringExpression("code", Expression.Operator.EQ, (String)content.getValue("code")), new StringExpression("catalog", Expression.Operator.EQ, newCatalog)})))).stream().findAny().isPresent()) {
                HashMap<String, I18nizableText> params = new HashMap<String, I18nizableText>();
                params.put("contentType", this._contentTypeHelper.getContentTypeLabel(content));
                params.put("code", new I18nizableText((String)content.getValue("code")));
                params.put("catalog", new I18nizableText(this._catalogsManager.getCatalog(newCatalog).getTitle()));
                params.put("lang", this._languagesManager.getLanguage(content.getLanguage()).getLabel());
                result.addError(new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_UNICITY_VALIDATOR_ERROR", params));
            }
        }
        return result;
    }
}

