/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.validator;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.contenttype.validation.AbstractContentValidator;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.data.holder.group.IndexableRepeater;
import org.ametys.cms.data.holder.group.IndexableRepeaterEntry;
import org.ametys.cms.repository.Content;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.data.EducationalPath;
import org.ametys.odf.program.Program;
import org.ametys.odf.skill.ODFSkillsHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.model.RepeaterDefinition;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.i18n.I18nizableTextParameter;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.disableconditions.DefaultDisableConditionsEvaluator;
import org.ametys.runtime.model.disableconditions.DisableConditionsEvaluator;
import org.ametys.runtime.parameter.ValidationResult;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class CourseMccSkillsValidator
extends AbstractContentValidator
implements Serviceable,
Initializable {
    private static final String __MCC_SESSION1 = "mccSession1";
    private static final String __MCC_SESSION2 = "mccSession2";
    private static final String __MCC_SESSION_COMMON = "common";
    private static final String __MCC_SESSION_PATH = "path";
    private static final String __MCC_SESSION_NOTES = "notes";
    private static final String __MCC_SESSION_NOTES_SKILLS = "skills";
    private static final String __MCC_SESSION_NOTES_SKILLS_SKILL = "skill";
    private static final String __MCC_SESSION_NOTES_SKILLS_PATH = "path";
    private static final String __SKILLS_BY_PROGRAMS_CACHE_ID = CourseMccSkillsValidator.class.getName() + "$skillsByPrograms";
    private DisableConditionsEvaluator _disableConditionsEvaluator;
    private ODFHelper _odfHelper;
    private ODFSkillsHelper _odfSkillsHelper;
    private AmetysObjectResolver _resolver;
    private AbstractCacheManager _cacheManager;
    private boolean _isSkillsEnabled;

    public void service(ServiceManager manager) throws ServiceException {
        this._disableConditionsEvaluator = (DisableConditionsEvaluator)manager.lookup(DefaultDisableConditionsEvaluator.ROLE);
        this._odfHelper = (ODFHelper)manager.lookup(ODFHelper.ROLE);
        this._odfSkillsHelper = (ODFSkillsHelper)manager.lookup(ODFSkillsHelper.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
    }

    public void initialize() throws ConfigurationException {
        super.initialize();
        this._isSkillsEnabled = (Boolean)Config.getInstance().getValue("odf.skills.enabled");
        if (!this._cacheManager.hasCache(__SKILLS_BY_PROGRAMS_CACHE_ID)) {
            this._cacheManager.createRequestCache(__SKILLS_BY_PROGRAMS_CACHE_ID, new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CACHE_SKILLS_BY_PROGRAMS_LABEL"), new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CACHE_SKILLS_BY_PROGRAMS_DESCRIPTION"), true);
        }
    }

    private Set<String> _getProgramMicroSkills(String programId) {
        Cache cache = this._cacheManager.get(__SKILLS_BY_PROGRAMS_CACHE_ID);
        return (Set)cache.get((Object)programId, this::_populateCacheEntry);
    }

    private Set<String> _populateCacheEntry(String id) {
        try {
            Content content = (Content)this._resolver.resolveById(id);
            if (content instanceof Program) {
                Program program = (Program)content;
                return this._odfSkillsHelper.getProgramMicroSkills(program).collect(Collectors.toSet());
            }
        }
        catch (AmetysRepositoryException ametysRepositoryException) {
            // empty catch block
        }
        return null;
    }

    public ValidationResult validate(Content content) {
        ValidationResult result = new ValidationResult();
        if (this._isSkillsEnabled && content instanceof Course) {
            Course course = (Course)content;
            Optional<EducationalPath> courseEducationalPath = this._getEducationalPath(course);
            result.addResult(this._checkSession(course, __MCC_SESSION1, courseEducationalPath));
            result.addResult(this._checkSession(course, __MCC_SESSION2, courseEducationalPath));
        }
        return result;
    }

    private ValidationResult _checkSession(Course course, String mccSession, Optional<EducationalPath> courseEducationalPath) {
        ValidationResult result = new ValidationResult();
        RepeaterDefinition mccSessionDefinition = (RepeaterDefinition)course.getDefinition(mccSession);
        if (!this._disableConditionsEvaluator.evaluateDisableConditions((ModelItem)mccSessionDefinition, mccSession, (Object)course)) {
            RepeaterDefinition noteDefinition = (RepeaterDefinition)mccSessionDefinition.getModelItem(__MCC_SESSION_NOTES);
            HashMap<String, I18nizableText> i18nParams = new HashMap<String, I18nizableText>();
            i18nParams.put("sessionRepeater", mccSessionDefinition.getLabel());
            i18nParams.put("noteRepeater", noteDefinition.getLabel());
            i18nParams.put("skillRepeater", noteDefinition.getModelItem(__MCC_SESSION_NOTES_SKILLS).getLabel());
            Optional.ofNullable(course.getRepeater(mccSession)).map(IndexableRepeater::getEntries).map(Collection::stream).orElseGet(() -> Stream.of(new IndexableRepeaterEntry[0])).map(entry -> this._checkSessionEntry((IndexableRepeaterEntry)entry, courseEducationalPath, (Map<String, I18nizableTextParameter>)i18nParams)).forEach(arg_0 -> ((ValidationResult)result).addResult(arg_0));
        }
        return result;
    }

    private ValidationResult _checkSessionEntry(IndexableRepeaterEntry sessionEntry, Optional<EducationalPath> courseEducationalPath, Map<String, I18nizableTextParameter> commonI18nParams) {
        ValidationResult result = new ValidationResult();
        HashMap<String, I18nizableTextParameter> i18nParams = new HashMap<String, I18nizableTextParameter>(commonI18nParams);
        i18nParams.put("sessionPosition", (I18nizableTextParameter)new I18nizableText(Integer.toString(sessionEntry.getPosition())));
        Optional<EducationalPath> sessionEntryEducationalPath = courseEducationalPath.or(() -> Optional.of(sessionEntry).filter(entry -> (Boolean)entry.getValue(__MCC_SESSION_COMMON, true, (Object)true) == false).map(entry -> (EducationalPath)entry.getValue("path")));
        Optional.ofNullable(sessionEntry.getRepeater(__MCC_SESSION_NOTES)).map(IndexableRepeater::getEntries).map(Collection::stream).orElseGet(() -> Stream.of(new IndexableRepeaterEntry[0])).map(noteEntry -> this._checkNoteEntry((IndexableRepeaterEntry)noteEntry, sessionEntryEducationalPath, (Map<String, I18nizableTextParameter>)i18nParams)).forEach(arg_0 -> ((ValidationResult)result).addResult(arg_0));
        return result;
    }

    private ValidationResult _checkNoteEntry(IndexableRepeaterEntry noteEntry, Optional<EducationalPath> sessionEntryEducationalPath, Map<String, I18nizableTextParameter> commonI18nParams) {
        ValidationResult result = new ValidationResult();
        HashMap<String, I18nizableTextParameter> noteI18nParams = new HashMap<String, I18nizableTextParameter>(commonI18nParams);
        noteI18nParams.put("notePosition", (I18nizableTextParameter)new I18nizableText(Integer.toString(noteEntry.getPosition())));
        HashMap<EducationalPath, Set> skillsByPath = new HashMap<EducationalPath, Set>();
        List skillEntries = Optional.ofNullable(noteEntry.getRepeater(__MCC_SESSION_NOTES_SKILLS)).map(IndexableRepeater::getEntries).map(Collection::stream).orElseGet(() -> Stream.of(new IndexableRepeaterEntry[0])).toList();
        for (IndexableRepeaterEntry skillEntry : skillEntries) {
            String programId;
            Set<String> programMicroSkills;
            ContentValue skill = (ContentValue)skillEntry.getValue(__MCC_SESSION_NOTES_SKILLS_SKILL);
            EducationalPath educationalPath = sessionEntryEducationalPath.orElseGet(() -> (EducationalPath)skillEntry.getValue("path"));
            if (skill == null || educationalPath == null) continue;
            Set skillsForPath = skillsByPath.computeIfAbsent(educationalPath, __ -> new HashSet());
            if (!skillsForPath.add(skill)) {
                result.addError(this._buildDuplicationMessage(noteI18nParams, skill, educationalPath));
                continue;
            }
            if (educationalPath.getProgramItemIds().size() <= 0 || (programMicroSkills = this._getProgramMicroSkills(programId = (String)educationalPath.getProgramItemIds().get(0))) == null || programMicroSkills.contains(skill.getContentId())) continue;
            result.addError(this._buildInconsistentMessage(noteI18nParams, skillEntry.getPosition(), skill, programId));
        }
        return result;
    }

    public ValidationResult validate(Content content, Map<String, Object> values, View view) {
        ValidationResult result = new ValidationResult();
        return result;
    }

    private Optional<EducationalPath> _getEducationalPath(Course course) {
        return Optional.of(course).filter(c -> (Boolean)c.getValue("isShared") == false).map(arg_0 -> ((ODFHelper)this._odfHelper).getParentPrograms(arg_0)).filter(parents -> parents.size() == 1).map(Collection::stream).flatMap(Stream::findFirst).map(xva$0 -> EducationalPath.of((ProgramItem[])new ProgramItem[]{xva$0}));
    }

    private I18nizableText _buildDuplicationMessage(Map<String, I18nizableTextParameter> commonI18nParams, ContentValue skill, EducationalPath educationalPath) {
        HashMap<String, I18nizableTextParameter> i18nParams = new HashMap<String, I18nizableTextParameter>(commonI18nParams);
        i18nParams.put(__MCC_SESSION_NOTES_SKILLS_SKILL, (I18nizableTextParameter)new I18nizableText(skill.getContentIfExists().map(Content::getTitle).orElseGet(() -> skill.getContentId())));
        i18nParams.put("educationalPath", (I18nizableTextParameter)new I18nizableText(this._odfHelper.getEducationalPathAsString(educationalPath)));
        return new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_COURSE_MCCSKILLS_VALIDATOR_ERROR_DUPLICATED", i18nParams);
    }

    private I18nizableText _buildInconsistentMessage(Map<String, I18nizableTextParameter> commonI18nParams, int skillPosition, ContentValue skill, String programId) {
        HashMap<String, I18nizableTextParameter> i18nParams = new HashMap<String, I18nizableTextParameter>(commonI18nParams);
        i18nParams.put("skillPosition", (I18nizableTextParameter)new I18nizableText(Integer.toString(skillPosition)));
        i18nParams.put(__MCC_SESSION_NOTES_SKILLS_SKILL, (I18nizableTextParameter)new I18nizableText(skill.getContentIfExists().map(Content::getTitle).orElseGet(() -> skill.getContentId())));
        i18nParams.put("program", (I18nizableTextParameter)new I18nizableText(((Program)this._resolver.resolveById(programId)).getTitle()));
        return new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_COURSE_MCCSKILLS_VALIDATOR_ERROR_INCONSISTENT", i18nParams);
    }
}

