<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:su="org.ametys.core.util.StringUtils"
                              xmlns:odf="org.ametys.plugins.odfweb.xslt.OdfXSLTHelper"
                              exclude-result-prefixes="odf su">
    
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/utils.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/xls.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/report/elpcompetences/legende2xls.xsl"/>
    
    <xsl:variable name="referenceTables">
        <xsl:copy-of select="odf:getTableRefItems('odf-enumeration.CourseNature', /report/lang, true())"/>
    </xsl:variable>
    
    <xsl:variable name="programId" select="/report/programId"/>
    
    <xsl:variable name="nbColumnsMaquette" select="8"/>
    <xsl:variable name="nbSkillsColumns" select="count(/report/skills/macro/micro)"/>
    <xsl:variable name="nbColumns" select="$nbColumnsMaquette + $nbSkillsColumns"/>
    <xsl:param name="titleColumnPosition" select="3"/>
    
    <xsl:template name="css-styles">
        <xsl:call-template name="css-styles-skills"/>
    </xsl:template>
    
    <xsl:template name="css-styles-skills">
        table
        {
            font-size: 7.5pt;
            width: 100%;
            padding: 0px;
            margin: 0px;
            border-spacing: 0;
            border-collapse: collapse;
        }
        
        table thead td.main-title1
        {
            background-color: white;
            color: #000080;
            font-size: 20pt;
        }
        
        table thead td.main-title2
        {
            background-color: white;
            color: #000080;
            font-size: 18pt;
        }
        
        table thead td.main-title3
        {
            background-color: white;
            color: #000080;
            font-size: 16pt;
        }
        
        table thead td.main-title4
        {
            background-color: white;
            color: #000080;
        }
        
        table tr.new-header td
        {
            border-top: 1pt dashed lightgrey;
            font-size: 10pt;
        }
        
        th.maquette
        {
            vertical-align: middle;
            font-weight: bold;
            text-align: center;
            background-color: #EEEEFF;
            border: 0.5pt #000080 solid;
            color: #000080;
        }
        
        th.skills
        {
            vertical-align: middle;
            font-weight: bold;
            text-align: center;
            background-color: #000080;
            border: 0.5pt white solid;
            color: white;
        }
        
        th.macroSkills
        {
            vertical-align: middle;
            font-weight: bold;
            text-align: center;
            background-color: #0000A0;
            border: 0.5pt white solid;
            color: white;
        }
        
        th.microSkills
        {
            vertical-align: middle;
            font-weight: bold;
            text-align: center;
            background-color: #0020C2;
            border: 0.5pt white solid;
            color: white;
        }
        
        .codeAmetys
        {
            color: #777777;
        }
        
        
        td.blockingMicroSkill
        {
            border-left:0.5pt solid  #333333;
            text-align:center;
            color: red;
            font-weight: bold;
        }
        
        thead th
        {
            padding: 5px;
            margin: 0px;
        }
        
        tbody td 
        { 
            padding: 0px;
            margin: 0px;
            border-bottom:0.5pt solid  #333333;
            border-right:0.5pt solid  #333333;
        }
        
        .legend td
        {
            border-bottom: none;
            border-right: none;
            font-size: 8.0pt;
        }
        
        .legend-title
        {
            color: #000080;
            font-weight: bold;
            padding-bottom: 3.0pt;
            font-size: 8.0pt;
        }
        
        .legend td.blockingMicroSkill
        {
            padding-left: 3mm;
            text-align:left;
        }
        
        .centered
        {
            text-align: center;
        }
    </xsl:template>
    
    <xsl:template name="table-head" >
        <xsl:apply-templates select="program|subProgram|container" mode="title" />
        <xsl:call-template name="table-header"/>
    </xsl:template>
    
    <xsl:template name="table-body">
        <xsl:apply-templates select="program|subProgram|container"/>
        <xsl:call-template name="legende"/>
    </xsl:template>
    
    <xsl:template match="program|subProgram|container" mode="title">
        <tr><td colspan="{$nbColumns}" class="main-title1"><xsl:value-of select="su:sanitizeXlsHtml(title)"/></td></tr>
        <xsl:call-template name="catalog-title"/>
        <xsl:if test="/report/path">
            <tr><td colspan="{$nbColumns}" class="main-title3"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_ELP_COMPETENCES_HEADER_INCLUDES"/></td></tr>
            <xsl:for-each select="/report/path">
                <tr><td colspan="{$nbColumns}" class="main-title3">&#x2022; <xsl:value-of select="."/></td></tr>
            </xsl:for-each>
            <tr><td></td></tr>
        </xsl:if>
        <tr>
            <td class="main-title4" colspan="{$nbColumns}">
                <i18n:translate>
                    <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_DATE"/>
                    <i18n:param><i18n:date-time pattern="dd/MM/yyyy HH:mm"></i18n:date-time></i18n:param>
                </i18n:translate>
            </td>
        </tr>
        <tr class="new-header"><td colspan="{$nbColumns}">&#160;</td></tr>
    </xsl:template>
    
    <xsl:template name="catalog-title">
        <tr><td colspan="{$nbColumns}" class="main-title2"><xsl:apply-templates select="." mode="catalog"/></td></tr>
    </xsl:template>
    
    <xsl:template match="program|subProgram|container" mode="catalog">
        <xsl:value-of select="/report/catalog"/>
    </xsl:template>
    
    <xsl:template name="table-header">
        <!-- First row to group titles -->
        <tr>
            <th class="maquette" colspan="{$nbColumnsMaquette}">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_ELP_COMPETENCES_COL_MAQUETTE"/>
            </th>
            <th class="skills" colspan="{$nbSkillsColumns}">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_ELP_COMPETENCES_COL_SKILLS"/>
            </th>
        </tr>
        
        <!-- Second row with types and macro skills -->
        <tr>
            <th class="maquette" colspan="2">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_ELP_COMPETENCES_COL_YEAR"/>
            </th>
            <th class="maquette" colspan="2">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_ELP_COMPETENCES_COL_SEMESTER"/>
            </th>
            <th class="maquette">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_ELP_COMPETENCES_COL_COURSELIST"/>
            </th>
            <th class="maquette" colspan="3">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_ELP_COMPETENCES_COL_COURSE"/>
            </th>
            <xsl:for-each select="/report/skills/macro">
                <th class="macroSkills" colspan="{count(micro)}">
                    <xsl:if test="code != ''">
                        <xsl:value-of select="code"/>
                        <xsl:text> </xsl:text>
                    </xsl:if>
                    <xsl:value-of select="su:sanitizeXlsHtml(title)"/>
                </th>
            </xsl:for-each>
        </tr>
        
        <!-- Third row with attributes and micro skills -->
        <tr>
            <th style="width: 2cm;" class="maquette">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_ELP_COMPETENCES_COL_CODE"/>
            </th>
            <th style="width: 5cm;" class="maquette">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_ELP_COMPETENCES_COL_LABEL"/>
            </th>
            <th style="width: 2cm;" class="maquette">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_ELP_COMPETENCES_COL_CODE"/>
            </th>
            <th style="width: 5cm;" class="maquette">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_ELP_COMPETENCES_COL_LABEL"/>
            </th>
            <th style="width: 2cm;" class="maquette">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_ELP_COMPETENCES_COL_TYPE"/>
            </th>
            <th style="width: 2cm;" class="maquette">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_ELP_COMPETENCES_COL_NATURE"/>
            </th>
            <th style="width: 2cm;" class="maquette">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_ELP_COMPETENCES_COL_CODE"/>
            </th>
            <th style="width: 8cm;" class="maquette">
                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_ELP_COMPETENCES_COL_LABEL"/>
            </th>
            <xsl:for-each select="/report/skills/macro/micro">
                <th class="microSkills">
                    <xsl:if test="code != ''">
                        <xsl:value-of select="code"/>
                        <xsl:text> </xsl:text>
                    </xsl:if>
                    <xsl:value-of select="title"/>
                </th>
            </xsl:for-each>
        </tr>
    </xsl:template>
    
    <xsl:template match="program|subProgram|container">
        <xsl:apply-templates select="subProgram|container|courseList"/>
    </xsl:template>
    
    <xsl:template match="courseList">
        <xsl:param name="depth" select="0" />
    
        <xsl:apply-templates select="course">
            <xsl:with-param name="depth" select="$depth"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="course">
        <xsl:param name="depth"/>
        
        <tr>
            <!-- Year -->
            <xsl:apply-templates select="." mode="container-filter">
                <xsl:with-param name="nature">annee</xsl:with-param>
            </xsl:apply-templates>
            
            <!-- Semester -->
            <xsl:apply-templates select="." mode="container-filter">
                <xsl:with-param name="nature">semestre</xsl:with-param>
            </xsl:apply-templates>
            
            <!-- Parent course list -->
            <xsl:apply-templates select=".." mode="course"/>
            
            <!-- Current course -->
            <xsl:apply-templates select="." mode="course">
                <xsl:with-param name="depth" select="$depth"/>
            </xsl:apply-templates>
            
            <!-- Skills -->
            <xsl:apply-templates select="." mode="skills"/>
        </tr>
        
        <xsl:apply-templates select="courseList">
            <xsl:with-param name="depth" select="$depth + 1"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="course" mode="container-filter">
        <xsl:param name="nature"/>
        
        <xsl:variable name="filteredContainer" select="ancestor::container[nature/code = $nature][position() = last()]"/>
        
        <xsl:choose>
            <xsl:when test="$filteredContainer">
                <xsl:apply-templates select="$filteredContainer" mode="cell-code"/>
                <xsl:apply-templates select="$filteredContainer" mode="cell-title"/>
            </xsl:when>
            <xsl:otherwise>
                <td/>
                <td/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="courseList" mode="course">
        <td><xsl:value-of select="choiceType"/></td>
    </xsl:template>
    
    <xsl:template match="course" mode="course">
        <xsl:param name="depth" select="0"/>
        <xsl:apply-templates select="." mode="cell-nature"/>
        <xsl:apply-templates select="." mode="cell-code"/>
        <xsl:apply-templates select="." mode="cell-title">
            <xsl:with-param name="depth" select="$depth"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="*" mode="cell-code">
        <td class="codeAmetys"><xsl:apply-templates select="." mode="code"/></td>
    </xsl:template>
    
    <xsl:template match="*" mode="cell-title">
        <xsl:param name="depth" select="0"/>
        <td>
            <xsl:call-template name="recursive-print">
                <xsl:with-param name="times" select="$depth" />
            </xsl:call-template>
            <xsl:apply-templates select="." mode="cell-title-inner"/>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-title-inner">
        <xsl:if test="shortLabel != ''">
            <xsl:value-of select="su:sanitizeXlsHtml(shortLabel)"/><xsl:text> </xsl:text>
        </xsl:if>
        <xsl:value-of select="su:sanitizeXlsHtml(title)" />
    </xsl:template>
    
    <xsl:template match="*" mode="cell-title-inner">
        <xsl:value-of select="su:sanitizeXlsHtml(title)"/>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-nature">
        <xsl:variable name="nature">
            <xsl:call-template name="displayCodeOrShortLabel">
                <xsl:with-param name="contentId" select="courseType/@id"/>
            </xsl:call-template>
        </xsl:variable>
        
        <td>
            <xsl:value-of select="su:sanitizeXlsHtml($nature)" />
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="skills">
        <xsl:variable name="courseMicroSkillsForProgram" select="acquiredMicroSkills/entry[program/@id = $programId]"/>
        
        <xsl:for-each select="/report/skills/macro/micro">
            <xsl:variable name="currentSkillId" select="@id"/>
            <td>
                <xsl:if test="$courseMicroSkillsForProgram/microSkills[@id = $currentSkillId]">
                    <xsl:attribute name="class">
                        <xsl:choose>
                            <xsl:when test="@isBlocking = 'true'">blockingMicroSkill</xsl:when>
                            <xsl:otherwise>centered</xsl:otherwise>
                        </xsl:choose>
                    </xsl:attribute>
                    <xsl:text>X</xsl:text>
                </xsl:if>
            </td>
        </xsl:for-each>
    </xsl:template>
</xsl:stylesheet>
