/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.clientsideelement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.cms.clientsideelement.SmartContentMenu;
import org.ametys.cms.repository.Content;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.program.Container;
import org.ametys.plugins.odfpilotage.helper.MCCWorkflowHelper;
import org.ametys.plugins.odfpilotage.rule.RulesManager;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class MCCWorkflowMenu
extends SmartContentMenu {
    protected MCCWorkflowHelper _mccWorkflowHelper;
    protected ODFHelper _odfHelper;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._mccWorkflowHelper = (MCCWorkflowHelper)((Object)manager.lookup(MCCWorkflowHelper.ROLE));
        this._odfHelper = (ODFHelper)manager.lookup(ODFHelper.ROLE);
    }

    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        MCCWorkflowHelper.MCCWorkflowStep mccStatus;
        String mccStatusName;
        List scripts = super.getScripts(ignoreRights, contextParameters);
        if (!scripts.isEmpty() && StringUtils.isNotEmpty((CharSequence)(mccStatusName = (String)((ClientSideElement.Script)scripts.get(0)).getParameters().get("mcc-status"))) && MCCWorkflowHelper.MCCWorkflowStep.RULES_VALIDATED.equals((Object)(mccStatus = MCCWorkflowHelper.MCCWorkflowStep.valueOf(mccStatusName))) && !RulesManager.isRulesEnabled()) {
            return List.of();
        }
        return scripts;
    }

    @Callable(rights={""})
    public Map<String, Object> getStatus(List<String> containerIds, String mccStatus) {
        Map results = super.getStatus(containerIds);
        results.put("valid-contents", new ArrayList());
        results.put("active-contents", new ArrayList());
        results.put("noyear-contents", new ArrayList());
        List activeContents = (List)results.get("active-contents");
        List validContents = (List)results.get("valid-contents");
        List noYearContents = (List)results.get("noyear-contents");
        List allrightContents = (List)results.get("allright-contents");
        for (Map allRightContent : allrightContents) {
            String containerId = (String)allRightContent.get("id");
            Container container = (Container)this._resolver.resolveById(containerId);
            this._getStatus(container, MCCWorkflowHelper.MCCWorkflowStep.valueOf(mccStatus), activeContents, validContents, noYearContents);
        }
        List<Object> activeContentIds = activeContents.stream().map(p -> p.get("id")).toList();
        results.put("allright-contents", allrightContents.stream().filter(p -> activeContentIds.contains(p.get("id"))).toList());
        return results;
    }

    protected boolean _hasReadAccess(Content content) {
        return this._rightManager.currentUserHasRight("ODF_Pilotage_See_MCCHistory_Rights", (Object)content) == RightManager.RightResult.RIGHT_ALLOW;
    }

    protected void _getStatus(Container container, MCCWorkflowHelper.MCCWorkflowStep mccStatus, List<Map<String, Object>> activeContents, List<Map<String, Object>> validContents, List<Map<String, Object>> noYearContents) {
        Map defaultContentParams = this.getContentDefaultParameters((Content)container);
        if (!this._odfHelper.isContainerOfTypeYear(container)) {
            HashMap<String, I18nizableText> noYearContentParams = new HashMap<String, I18nizableText>(defaultContentParams);
            noYearContentParams.put("description", this._getNoYearDescription((Content)container));
            noYearContents.add(noYearContentParams);
            return;
        }
        if (this._mccWorkflowHelper.getCurrentSteps(container).contains((Object)mccStatus)) {
            HashMap<String, I18nizableText> activeContentParams = new HashMap<String, I18nizableText>(defaultContentParams);
            activeContentParams.put("description", this._getActiveDescription((Content)container));
            activeContents.add(activeContentParams);
        } else if (this._mccWorkflowHelper.isStepValid(container, mccStatus)) {
            HashMap<String, I18nizableText> validContentParams = new HashMap<String, I18nizableText>(defaultContentParams);
            validContentParams.put("description", this._getValidDescription((Content)container));
            validContents.add(validContentParams);
        }
    }

    protected I18nizableText _getActiveDescription(Content content) {
        ArrayList<String> workflowI18nParameters = new ArrayList<String>();
        workflowI18nParameters.add(this._contentHelper.getTitle(content));
        I18nizableText ed = (I18nizableText)this._script.getParameters().get("active-content-description");
        return new I18nizableText(ed.getCatalogue(), ed.getKey(), workflowI18nParameters);
    }

    protected I18nizableText _getValidDescription(Content content) {
        ArrayList<String> workflowI18nParameters = new ArrayList<String>();
        workflowI18nParameters.add(this._contentHelper.getTitle(content));
        I18nizableText ed = (I18nizableText)this._script.getParameters().get("valid-content-description");
        return new I18nizableText(ed.getCatalogue(), ed.getKey(), workflowI18nParameters);
    }

    protected I18nizableText _getNoYearDescription(Content content) {
        ArrayList<String> workflowI18nParameters = new ArrayList<String>();
        workflowI18nParameters.add(this._contentHelper.getTitle(content));
        I18nizableText ed = (I18nizableText)this._script.getParameters().get("noyear-content-description");
        return new I18nizableText(ed.getCatalogue(), ed.getKey(), workflowI18nParameters);
    }
}

