<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:import href="view://stylesheets/io/docbook2html.xsl"/>
    
    <xsl:template match="/*">
        <html>
            <head>
                <style>
                    <xsl:call-template name="css-styles"/>
                </style>
            </head>
            <body>
                <table>
                    <xsl:call-template name="table-attributes"/>
                    <thead>
                        <xsl:call-template name="table-head"/>
                    </thead>
                    <tbody>
                        <xsl:call-template name="table-body"/>
                    </tbody>
                </table>
            </body>
        </html>
    </xsl:template>
    
    <xsl:template name="table-attributes"/>
    
    <xsl:template name="css-styles"/>
    
    <!-- Newline to hyphen because br tag causes a new line. -->
    <xsl:template name="text.nl2hyphen">
        <xsl:param name="input"/>
        <xsl:param name="s1"><xsl:text>
</xsl:text></xsl:param>
        
        <xsl:choose>
            <xsl:when test="contains($input, $s1)">
                <xsl:variable name="rest">
                    <xsl:call-template name="text.nl2hyphen">
                        <xsl:with-param name="input" select="substring-after($input, $s1)"/>
                        <xsl:with-param name="s1" select="$s1"/>
                    </xsl:call-template>
                </xsl:variable>
                <xsl:value-of select="substring-before($input, $s1)"/>
                <xsl:text> - </xsl:text>
                <xsl:copy-of select="$rest"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$input"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>