/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.actions;

import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;

import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.workflow.ContentWorkflowAction;
import org.ametys.cms.workflow.ContentWorkflowHelper;
import org.ametys.odf.data.EducationalPath;
import org.ametys.odf.rights.ODFRightHelper;
import org.ametys.odf.workflow.EditContextualizedDataFunction;
import org.ametys.plugins.workflow.AbstractWorkflowComponent;

import com.opensymphony.workflow.InvalidInputException;
import com.opensymphony.workflow.WorkflowException;

/**
 * Action to edit MCC course.
 */
public class MCCCourseSaveAction extends ContentWorkflowAction
{
    private ContentWorkflowHelper _contentWorkflowHelper;

    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _contentWorkflowHelper = (ContentWorkflowHelper) smanager.lookup(ContentWorkflowHelper.ROLE);
    }
    
    @SuppressWarnings("unchecked")
    @Override
    protected Map _act(Redirector redirector, Map objectModel, String source, Parameters parameters, int actionId, Map inputs) throws InvalidInputException, WorkflowException
    {
        Map<String, Object> jsParameters = (Map<String, Object>) inputs.get(AbstractWorkflowComponent.CONTEXT_PARAMETERS_KEY);
        
        WorkflowAwareContent content = _getContent(objectModel);
        
        if (_contentWorkflowHelper.isAvailableAction(content, actionId))
        {
            return super._act(redirector, objectModel, source, parameters, actionId, inputs);
        }
        else
        {
            // Fallback to action 20
            List<List<String>> paths = (List<List<String>>) jsParameters.get("paths");
            
            if (paths != null)
            {
                List<EducationalPath> educationPaths = paths.stream()
                        .map(p -> EducationalPath.of(p.toArray(String[]::new)))
                        .toList();
               
                Request request = ObjectModelHelper.getRequest(objectModel);
                request.setAttribute(ODFRightHelper.REQUEST_ATTR_EDUCATIONAL_PATHS, educationPaths);
            }
            
            return super._act(redirector, objectModel, source, parameters, EditContextualizedDataFunction.EDIT_WORKFLOW_ACTION_ID, inputs);
        }
    }
}
