/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.course;

import java.util.Map;
import java.util.Optional;

import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.odf.course.Course;
import org.ametys.plugins.odfpilotage.helper.PilotageHelper;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.disableconditions.AbstractExternalDisableCondition;

/**
 * Disable condition used to block MCC fields is the course is excluded from MCC
 */
public class ExcludeFromMCCDisableCondition extends AbstractExternalDisableCondition implements Component, Serviceable
{
    private PilotageHelper _pilotageHelper;
    
    public void service(ServiceManager manager) throws ServiceException
    {
        _pilotageHelper = (PilotageHelper) manager.lookup(PilotageHelper.ROLE);
    }
    
    public <T> boolean evaluate(ModelItem definition, String dataPath, Optional<String> oldDataPath, Map<String, Object> values, Optional<T> object, Map<String, Object> contextualParameters)
    {
        // Only for courses
        Course course = object.filter(Course.class::isInstance)
                              .map(Course.class::cast)
                              .orElse(null);
        if (course != null)
        {
            return _pilotageHelper.isExcludedFromMCC(course) || _pilotageHelper.isParentExcludedInMCC(course);
        }

        return false;
    }
}
