/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.schedulable.helper;

import java.util.Map;

import org.quartz.JobDataMap;

import org.ametys.plugins.core.schedule.Scheduler;
import org.ametys.plugins.odfpilotage.report.impl.ConsistencyExtract;

import com.google.common.collect.ImmutableMap;

/**
 * Helper for the program and orgunit schedulables of the consistency report.
 */
public final class ConsistencyExtractSchedulableHelper
{
    /** The key for the analysis */
    public static final String JOBDATAMAP_ANALYSIS_KEY = "analysis";

    private ConsistencyExtractSchedulableHelper()
    {
        // Empty constructor
    }
    
    /**
     * Get the specific additionnal parameters for consistency report.
     * @param jobDataMap The map of parameters
     * @return The additional parameters
     */
    public static Map<String, String> getReportParameters(JobDataMap jobDataMap)
    {
        return ImmutableMap.of(ConsistencyExtract.PARAMETER_ANALYSIS, jobDataMap.getString(Scheduler.PARAM_VALUES_PREFIX + JOBDATAMAP_ANALYSIS_KEY));
    }
}
