/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.report.impl.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ametys.cms.content.compare.ContentComparatorResult;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.data.EducationalPath;

public class ProgramItemTree {
    private ProgramItemTree _parent;
    private ProgramItem _current;
    private List<ProgramItemTree> _children = new ArrayList<ProgramItemTree>();
    private ContentComparatorResult _change;
    private EducationalPath _path;

    private ProgramItemTree(ProgramItemTree parent, ProgramItem current, ContentComparatorResult change) {
        this._parent = parent;
        this._current = current;
        this._change = change;
    }

    private ProgramItemTree(ProgramItemTree parent, ProgramItem current) {
        this(parent, current, null);
    }

    public ProgramItemTree(ProgramItem current) {
        this(null, current);
    }

    public ProgramItemTree(ProgramItem current, ContentComparatorResult change) {
        this(null, current, change);
    }

    public ProgramItemTree addChild(ProgramItem child) {
        return this.addChild(child, null);
    }

    public ProgramItemTree addChild(ProgramItem child, ContentComparatorResult change) {
        ProgramItemTree childTree = this._createChild(child, change);
        this.addChild(childTree);
        return childTree;
    }

    protected void addChild(ProgramItemTree childTree) {
        this._children.add(childTree);
    }

    private ProgramItemTree _createChild(ProgramItem child, ContentComparatorResult change) {
        return new ProgramItemTree(this, child, change);
    }

    public ProgramItemTree getParent() {
        return this._parent;
    }

    public ProgramItem getCurrent() {
        return this._current;
    }

    public List<ProgramItemTree> getChildren() {
        return this._children;
    }

    public ContentComparatorResult getChange() {
        return this._change;
    }

    public EducationalPath getPath() {
        if (this._path == null) {
            return Optional.ofNullable(this._parent).map(ProgramItemTree::getPath).map(parentPath -> EducationalPath.of((EducationalPath)parentPath, (ProgramItem[])new ProgramItem[]{this._current})).orElseGet(() -> EducationalPath.of((ProgramItem[])new ProgramItem[]{this._current}));
        }
        return this._path;
    }

    public static enum ChangeType {
        ADDED,
        REMOVED,
        MODIFIED_OLD,
        MODIFIED_NEW;

    }
}

