<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:su="org.ametys.core.util.StringUtils"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    exclude-result-prefixes="su">
    
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/utils.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/xls.xsl"/>
    
    <xsl:template name="css-styles">
        thead tr th
        {
            font-weight: bold;
            text-align: center;
            background-color: darkblue;
            color: white;
            vertical-align: middle;
        }
        
        .ue td
        {
            font-weight: bold;
        }
    </xsl:template>
    
    <xsl:template name="table-attributes">
        <xsl:attribute name="border">1</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="table-head">
        <tr>
            <th rowspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_ORDRE"/></th>
            <th colspan="3"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_PROGRAM"/></th>
            <th colspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_SUBPROGRAM"/></th>
            <th colspan="5"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_STEP"/></th>
            <th colspan="4"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE_LIST"/></th>
            <th colspan="21"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE"/></th>
            <th colspan="4"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COURSE_PART"/></th>
            <th colspan="10"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_CALCULS"/></th>
            <th colspan="4"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_ETAPE_PORTEUSE"/></th>
            <th colspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_COUTS"/></th>
            <xsl:if test="count(columns/column) > 0">
                <th colspan="{count(columns/column)}"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_EFFECTIFS_VENTILES"/></th>
                <th colspan="{count(columns/column)}"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_TITLE_EQ_TD_VENTILES"/></th>
            </xsl:if>
        </tr>
        <tr>
            <!-- Formation -->
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_COMPOSANTE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_FORMATION"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_FORMATION_CODE"/></th>
            <!-- Parcours -->
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_PARCOURS"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_PARCOURS_CODE"/></th>
            <!-- Etape -->
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_ANNEE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_ANNEE_CODE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_COD_ETP"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_COD_VRS_ETP"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_ANNEE_NB_STUDENTS"/></th>
            <!-- Liste -->
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_CODE_ELP_PERE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_LISTE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_TYPE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_MIN"/></th>
            <!-- ELP -->
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_A_DES_FILS"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_PARTAGE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_OCCURRENCE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_PORTE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_NIVEAU"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_CREATION_DATE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_CODE_ELP_APOGEE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_NATURE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_LIBELLE_COURT"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_LIBELLE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_CODE_ELP"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_LIEU"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_ECTS"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_ELEMENT_STAGE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_CODE_SEMESTRE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_CODE_TYPE_PERIODE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_CODE_COMPOSANTE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_CODE_CIP"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_CODE_ANU"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_CALCUL_DES_CHARGES"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_DISCIPLINE"/></th>
            <!-- Heures d'enseignement -->
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_ENSEIGNEMENT_ELP_PORTEUR"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_ENSEIGNEMENT_TITRE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_ENSEIGNEMENT_CODE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_ENSEIGNEMENT_NATURE"/></th>
            <!-- Calculs -->
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_VOLUME"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_EFFECTIFS_LOCAL"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_EFFECTIFS_PREV_CALC"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_EFFECTIFS_PREV"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_EFFECTIFS_MAX"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_EFFECTIFS_MIN_SUP"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_NORME"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_GROUPES_CALCULES"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_GROUPES_A_OUVRIR"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_EQ_TD_TOTAL"/></th>
            <!-- Etape porteuse -->
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_ETAPE_PORTEUSE_CODE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_ETAPE_PORTEUSE_CODE_ETP"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_ETAPE_PORTEUSE_CODE_VRS_ETP"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_ETAPE_PORTEUSE_TITLE"/></th>
            <!-- Couts -->
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_EQTD_PRORATISEES"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_PILOTAGE_COUT_MAQUETTES_COLUMN_EQTD_PORTEES"/></th>
             <!-- Ventilation des effectifs -->
            <xsl:for-each select="columns/column">
                <th><xsl:value-of select="."/></th>
            </xsl:for-each>
            <!-- Ventilation des eqTD -->
            <xsl:for-each select="columns/column">
                <th><xsl:value-of select="."/></th>
            </xsl:for-each>
        </tr>
    </xsl:template>
    
    <xsl:template name="table-body">
        <xsl:for-each select="course">
            <xsl:choose>
                <xsl:when test="count(courseParts/coursePart) > 0">
                    <xsl:for-each select="courseParts/coursePart">
                        <xsl:call-template name="course">
                            <xsl:with-param name="currentCourse" select="../.."/>
                            <xsl:with-param name="currentCoursePart" select="/report/courseParts/coursePart[@id = current()/@id]"/>
                        </xsl:call-template>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="course">
                        <xsl:with-param name="currentCourse" select="."/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="course">
        <xsl:param name="currentCourse"/>
        <xsl:param name="currentCoursePart"/>
        
        <tr>
            <xsl:if test="$currentCourse/nature = 'UE'">
                <xsl:attribute name="class">ue</xsl:attribute>
            </xsl:if>
            
            <td><xsl:value-of select="$currentCourse/ordre"/></td>
            
            <!-- Formation -->
            <xsl:choose>
                <xsl:when test="$currentCourse/program">
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/program/orgUnits)"/></td>
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/program/title)"/></td>
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/program/code)"/></td>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="empty-cells">
                        <xsl:with-param name="nbCells" select="3"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
            
            <!-- Parcours -->
            <xsl:choose>
                <xsl:when test="$currentCourse/subProgram">
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/subProgram/title)"/></td>
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/subProgram/code)"/></td>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="empty-cells">
                        <xsl:with-param name="nbCells" select="2"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
            
            <!-- Année -->
            <xsl:choose>
                <xsl:when test="$currentCourse/year">
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/year/title)"/></td>
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/year/code)"/></td>
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/year/COD_ETP)"/></td>
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/year/COD_VRS_ETP)"/></td>
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/year/nbStudents)"/></td>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="empty-cells">
                        <xsl:with-param name="nbCells" select="5"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
            
            <!-- ELP père -->
            <xsl:choose>
                <xsl:when test="$currentCourse/parentCourse">
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/parentCourse/codeELPPere)"/></td>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="empty-cells">
                        <xsl:with-param name="nbCells" select="1"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
            
            <!-- Liste -->
            <xsl:choose>
                <xsl:when test="$currentCourse/courseList">
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/courseList/@displayName)"/></td>
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/courseList/@type)"/></td>
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/courseList/@minmax)"/></td>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="empty-cells">
                        <xsl:with-param name="nbCells" select="3"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
            
            <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/aDesFils)"/></td>
            
            <!-- Partage -->
            <xsl:choose>
                <xsl:when test="$currentCourse/partage">
                    <td><xsl:text>X</xsl:text></td>
                    <td><xsl:value-of select="$currentCourse/partage/@occurrences"/></td>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="empty-cells">
                        <xsl:with-param name="nbCells" select="2"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
            
            <!-- ELP -->
            <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/porte)"/></td>
            <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/niveau)"/></td>
            <td><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="long"><xsl:value-of select="$currentCourse/creationDate"/></i18n:date></td>
            <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/codeApogee)"/></td>
            <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/nature)"/></td>
            <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/libelleCourt)"/></td>
            <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/libelle)"/></td>
            <td><xsl:value-of select="$currentCourse/elpCode"/></td>
            <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/campus)"/></td>
            <td>
                <xsl:call-template name="display-double">
                    <xsl:with-param name="value"><xsl:value-of select="$currentCourse/ects"/></xsl:with-param>
                </xsl:call-template>
            </td>
            <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/stage)"/></td>
            <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/periode)"/></td>
            <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/periodeType)"/></td>
            <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/orgUnit/codeComposante)"/></td>
            <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/orgUnit/codeCIP)"/></td>
            <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/CodeAnu)"/></td>
            <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/calculCharges)"/></td>
            <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/discipline)"/></td>

            <!-- Heures d'enseignement et calculs -->
            <xsl:choose>
                <xsl:when test="$currentCoursePart">
                    <!-- Heure d'enseignement -->
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCoursePart/elpPorteur)"/></td>
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCoursePart/titre)"/></td>
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCoursePart/code)"/></td>
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCoursePart/nature)"/></td>
                    <!-- Calculs -->
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCoursePart/volumeHoraire)"/></td>
                    <td>
                        <!-- path = programName(/*)/subProgramName(/*)/yearName(/*)/parentCourseName(/*)/courseListName(/*)/courseName(/*) -->
                        <xsl:call-template name="display-double">
                            <xsl:with-param name="value"><xsl:value-of select="sum($currentCoursePart/effectif[@path = concat($currentCourse/@path, $currentCoursePart/@name)])"/></xsl:with-param>
                            <xsl:with-param name="showZero" select="true()" />
                        </xsl:call-template>
                    </td>
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCoursePart/effectifCalcule)"/></td>
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCoursePart/effectifPrevisionnel)"/></td>
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCoursePart/effectifMax)"/></td>
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCoursePart/effectifMinSup)"/></td>
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCoursePart/norme)"/></td>
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCoursePart/groupesCalcules)"/></td>
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCoursePart/groupesAOuvrir)"/></td>
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCoursePart/eqTDTotal)"/></td>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="empty-cells">
                        <xsl:with-param name="nbCells" select="14"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
            
            <!-- Etape porteuse -->
            <xsl:choose>
                <xsl:when test="$currentCourse/stepHolder">
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/stepHolder/code)"/></td>
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/stepHolder/etpCode)"/></td>
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/stepHolder/vrsEtpCode)"/></td>
                    <td><xsl:value-of select="su:sanitizeXlsHtml($currentCourse/stepHolder/title)"/></td>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="empty-cells">
                        <xsl:with-param name="nbCells" select="4"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
            
            <!-- Couts et ventilation-->
            <xsl:choose>
                <xsl:when test="$currentCoursePart">
                    <td>
                        <!-- path = programName(/*)/subProgramName(/*)/yearName(/*)/parentCourseName(/*)/courseListName(/*)/courseName(/*) -->
                        <xsl:call-template name="display-double">
                            <xsl:with-param name="value"><xsl:value-of select="sum($currentCoursePart/proratedEqTD[@path = concat($currentCourse/@path, $currentCoursePart/@name)])"/></xsl:with-param>
                            <xsl:with-param name="showZero" select="true()" />
                        </xsl:call-template>
                    </td>
                    <td>
                        <!-- path = programName(/*)/subProgramName(/*)/yearName(/*)/parentCourseName(/*)/courseListName(/*)/courseName(/*) -->
                        <xsl:call-template name="display-double">
                            <xsl:with-param name="value"><xsl:value-of select="sum($currentCoursePart/localEqTD[@path = concat($currentCourse/@path, $currentCoursePart/@name)])"/></xsl:with-param>
                            <xsl:with-param name="showZero" select="true()" />
                        </xsl:call-template>
                    </td>
            
                    <!-- Effectifs ventilés -->
                    <xsl:for-each select="/report/columns/column">
                        <td>
                            <!-- path = */containerName/* -->
                            <xsl:call-template name="display-double">
                                <xsl:with-param name="value"><xsl:value-of select="sum($currentCoursePart/effectif[contains(@path, concat('/', current()/@name, '/'))])"/></xsl:with-param>
                            </xsl:call-template>
                        </td>
                    </xsl:for-each>
                    
                    <!-- eqTD ventilés -->
                    <xsl:for-each select="/report/columns/column">
                        <td>
                            <!-- path = */containerName/* -->
                            <xsl:call-template name="display-double">
                                <xsl:with-param name="value"><xsl:value-of select="sum($currentCoursePart/proratedEqTD[contains(@path, concat('/', current()/@name, '/'))])"/></xsl:with-param>
                            </xsl:call-template>
                        </td>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="empty-cells">
                        <xsl:with-param name="nbCells" select="(count(/report/columns/column) * 2) + 2"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </tr>
    </xsl:template>
    
    <xsl:template name="empty-cells">
        <xsl:param name="nbCells" select="0"/>
        
        <xsl:if test="$nbCells > 0">
            <td/>
            <xsl:call-template name="empty-cells">
                <xsl:with-param name="nbCells" select="$nbCells - 1"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>
