/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.model.restrictions.RestrictedModelItem;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.search.cocoon.ContentGridComponent;
import org.ametys.cms.search.content.ContentValuesExtractorFactory;
import org.ametys.cms.search.model.SearchModel;
import org.ametys.cms.search.ui.model.SearchUIModel;
import org.ametys.cms.search.ui.model.SearchUIModelExtensionPoint;
import org.ametys.cms.workflow.ContentWorkflowHelper;
import org.ametys.core.ui.Callable;
import org.ametys.odf.data.EducationalPath;
import org.ametys.odf.rights.ODFRightHelper;
import org.ametys.odf.tree.ODFContentsTreeHelper;
import org.ametys.plugins.repository.model.ViewHelper;
import org.ametys.runtime.model.ViewItemAccessor;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public class ContentsWithViewTreeGridHelper
extends ODFContentsTreeHelper
implements Contextualizable,
Configurable {
    protected static final String REQUEST_ATTRIBUTE_SEARCHMODELNAME = ContentsWithViewTreeGridHelper.class.getName() + "$ContentViews";
    protected Context _context;
    protected ContentWorkflowHelper _contentWorkflowHelper;
    protected int _workflowEditActionId;
    private SearchUIModelExtensionPoint _searchUIModelExtensionPoint;
    private ContentValuesExtractorFactory _contentValuesExtractorFactory;
    private ContentGridComponent _contentGridComponent;

    public void configure(Configuration configuration) throws ConfigurationException {
        this._workflowEditActionId = configuration.getChild("workflowEditActionId").getValueAsInteger(2);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._searchUIModelExtensionPoint = (SearchUIModelExtensionPoint)smanager.lookup(SearchUIModelExtensionPoint.ROLE);
        this._contentValuesExtractorFactory = (ContentValuesExtractorFactory)smanager.lookup(ContentValuesExtractorFactory.ROLE);
        this._contentGridComponent = (ContentGridComponent)smanager.lookup(ContentGridComponent.ROLE);
        this._contentWorkflowHelper = (ContentWorkflowHelper)smanager.lookup(ContentWorkflowHelper.ROLE);
    }

    @Callable(rights={"*"})
    public boolean canEditRepeaterWithPath(String contentId, List<String> path) {
        WorkflowAwareContent content = (WorkflowAwareContent)this._ametysResolver.resolveById(contentId);
        Request request = ContextHelper.getRequest((Context)this._context);
        request.setAttribute(ODFRightHelper.REQUEST_ATTR_EDUCATIONAL_PATHS, List.of(EducationalPath.of((String[])((String[])path.toArray(String[]::new)))));
        return this._contentWorkflowHelper.isAvailableAction(content, 20);
    }

    @Callable(rights={"__READ_ACCESS"}, paramIndex=0, rightContext="right.assignment.context.content")
    public Map<String, Object> getRootNodeInformations(String contentId, String treeId, String searchModel) {
        Request request = ContextHelper.getRequest((Context)this._context);
        request.setAttribute(REQUEST_ATTRIBUTE_SEARCHMODELNAME, (Object)searchModel);
        return super.getRootNodeInformations(contentId, treeId);
    }

    @Callable(rights={"__READ_ACCESS"}, paramIndex=0, rightContext="right.assignment.context.content")
    public Map<String, Object> getNodeInformations(String contentId, List<String> path, String searchModel) {
        Request request = ContextHelper.getRequest((Context)this._context);
        request.setAttribute(REQUEST_ATTRIBUTE_SEARCHMODELNAME, (Object)searchModel);
        return this.getNodeInformations(contentId, path);
    }

    @Callable(rights={"__READ_ACCESS"}, paramIndex=0, rightContext="right.assignment.context.content")
    public Map<String, Object> getChildrenContent(String contentId, List<String> path, String treeId, String searchModelName) {
        Request request = ContextHelper.getRequest((Context)this._context);
        request.setAttribute(REQUEST_ATTRIBUTE_SEARCHMODELNAME, (Object)searchModelName);
        return super.getChildrenContent(contentId, path, treeId);
    }

    protected Map<String, Object> content2Json(Content content, List<String> path) {
        Map content2Json = super.content2Json(content, path);
        Request request = ContextHelper.getRequest((Context)this._context);
        String searchModelName = (String)request.getAttribute(REQUEST_ATTRIBUTE_SEARCHMODELNAME);
        if (searchModelName != null) {
            SearchUIModel searchUIModel = (SearchUIModel)this._searchUIModelExtensionPoint.getExtension(searchModelName);
            Set contentTypesOfModel = searchUIModel.getContentTypes(Map.of());
            boolean jsonContentData = contentTypesOfModel.stream().anyMatch(cType -> this._contentTypesHelper.isInstanceOf(content, cType));
            if (jsonContentData) {
                this.fillContentData(content, searchUIModel, path, content2Json);
            } else {
                content2Json.put("notEditableData", true);
            }
        } else {
            content2Json.put("notEditableData", true);
        }
        return content2Json;
    }

    protected void fillContentData(Content content, SearchUIModel searchUIModel, List<String> path, Map<String, Object> content2Json) {
        content2Json.put("data", this.getContentData(content, searchUIModel));
        if (this._contentWorkflowHelper.isAvailableAction((WorkflowAwareContent)content, this._workflowEditActionId)) {
            content2Json.put("notEditableDataIndex", this.canEdit((ViewItemAccessor)searchUIModel.getResultItems(Map.of()), content));
        } else {
            content2Json.put("notEditableData", true);
        }
    }

    protected Map<String, Object> getContentData(Content content, SearchUIModel searchUIModel) {
        ContentValuesExtractorFactory.SearchModelContentValuesExtractor valuesExtractor = this._contentValuesExtractorFactory.create((SearchModel)searchUIModel);
        return (Map)this._contentGridComponent.getContentData(content, (ContentValuesExtractorFactory.ContentValuesExtractor)valuesExtractor, null, Map.of()).get("properties");
    }

    protected List<String> canEdit(ViewItemAccessor viewItemAcessor, Content content) {
        ArrayList<String> results = new ArrayList<String>();
        ViewHelper.visitView((ViewItemAccessor)viewItemAcessor, (element, definition) -> {
            RestrictedModelItem restrictedModelItem;
            if (definition instanceof RestrictedModelItem && !(restrictedModelItem = (RestrictedModelItem)definition).canWrite((Object)content)) {
                results.add(definition.getPath());
            }
        }, (group, definition) -> results.addAll(this.canEdit((ViewItemAccessor)group, content)), (group, definition) -> {
            RestrictedModelItem restrictedModelItem;
            if (definition instanceof RestrictedModelItem && !(restrictedModelItem = (RestrictedModelItem)definition).canWrite((Object)content)) {
                results.add(definition.getPath());
            } else {
                results.addAll(this.canEdit((ViewItemAccessor)group, content));
            }
        }, group -> results.addAll(this.canEdit((ViewItemAccessor)group, content)));
        return results;
    }
}

