/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.cms.contenttype.validation.AbstractContentValidator;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.data.holder.group.IndexableRepeater;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeaterEntry;
import org.ametys.plugins.repository.data.holder.impl.DataHolderHelper;
import org.ametys.plugins.repository.data.holder.values.SynchronizableRepeater;
import org.ametys.plugins.repository.data.holder.values.SynchronizationContext;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.disableconditions.DefaultDisableConditionsEvaluator;
import org.ametys.runtime.model.disableconditions.DisableConditionsEvaluator;
import org.ametys.runtime.parameter.ValidationResult;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public abstract class AbstractRepeaterWithUniqueContentValidator
extends AbstractContentValidator
implements Serviceable {
    protected DisableConditionsEvaluator _disableConditionsEvaluator;

    public void service(ServiceManager manager) throws ServiceException {
        this._disableConditionsEvaluator = (DisableConditionsEvaluator)manager.lookup(DefaultDisableConditionsEvaluator.ROLE);
    }

    public ValidationResult validate(Content content) {
        ValidationResult result = new ValidationResult();
        String repeaterName = this.getRepeaterName();
        ModelItem repeaterDefinition = content.getDefinition(repeaterName);
        if (content.hasValue(repeaterName) && !this._disableConditionsEvaluator.evaluateDisableConditions(repeaterDefinition, repeaterName, (Object)content)) {
            HashSet<String> itemIds = new HashSet<String>();
            IndexableRepeater repeater = content.getRepeater(repeaterName);
            String contentDataName = this.getContentDataName();
            ModelItem contentDataDefinition = content.getDefinition(repeaterName + "/" + contentDataName);
            for (ModelAwareRepeaterEntry entry : repeater.getEntries()) {
                ContentValue item;
                String dataPath = repeaterName + "[" + entry.getPosition() + "]/" + contentDataName;
                if (this._disableConditionsEvaluator.evaluateDisableConditions(contentDataDefinition, dataPath, (Object)content) || (item = (ContentValue)entry.getValue(this.getContentDataName())) == null || itemIds.add(item.getContentId())) continue;
                String title = item.getContentIfExists().map(Content::getTitle).orElse(item.getContentId());
                HashMap<String, I18nizableText> i18nParams = new HashMap<String, I18nizableText>();
                i18nParams.put("contentTitle", new I18nizableText(content.getTitle()));
                i18nParams.put("dataValueTitle", new I18nizableText(title));
                result.addError(new I18nizableText("plugin.odf-pilotage", this.getErrorKey(), i18nParams));
            }
        }
        return result;
    }

    public ValidationResult validate(Content content, Map<String, Object> values, View view) {
        List repeaterEntries;
        ValidationResult result = new ValidationResult();
        Object repeater = values.get(this.getRepeaterName());
        if (repeater instanceof SynchronizableRepeater) {
            SynchronizableRepeater synchronizableRepeater = (SynchronizableRepeater)repeater;
            v0 = synchronizableRepeater.getEntries();
        } else {
            v0 = repeaterEntries = List.of();
        }
        if (!repeaterEntries.isEmpty()) {
            HashSet<String> itemIds = new HashSet<String>();
            ModelItem modelItem = content.getDefinition(this.getRepeaterName() + "/" + this.getContentDataName());
            for (int i = 0; i < repeaterEntries.size(); ++i) {
                Map entry = (Map)repeaterEntries.get(i);
                int position = i + 1;
                Optional<String> oldDataPath = Optional.of(repeaterEntries).filter(SynchronizableRepeater.class::isInstance).map(SynchronizableRepeater.class::cast).flatMap(syncRepeater -> syncRepeater.getPreviousPosition(position)).map(previousPosition -> this.getRepeaterName() + "[" + previousPosition + "]/" + this.getContentDataName());
                Content repeaterContent = Optional.ofNullable(this.getContentDataName()).map(entry::get).map(value -> DataHolderHelper.getValueFromSynchronizableValue((Object)value, (ModelAwareDataHolder)content, (ModelItem)modelItem, (Optional)oldDataPath, (SynchronizationContext)SynchronizationContext.newInstance())).filter(ContentValue.class::isInstance).map(ContentValue.class::cast).flatMap(ContentValue::getContentIfExists).orElse(null);
                if (repeaterContent == null || itemIds.add(repeaterContent.getId())) continue;
                HashMap<String, I18nizableText> i18nParams = new HashMap<String, I18nizableText>();
                i18nParams.put("contentTitle", new I18nizableText(content.getTitle()));
                i18nParams.put("dataValueTitle", new I18nizableText(repeaterContent.getTitle()));
                result.addError(new I18nizableText("plugin.odf-pilotage", this.getErrorKey(), i18nParams));
            }
        }
        return result;
    }

    protected abstract String getRepeaterName();

    protected abstract String getContentDataName();

    protected abstract String getErrorKey();
}

