/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.workflow;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.workflow.AbstractContentWorkflowComponent;
import org.ametys.core.util.I18nUtils;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.plugins.workflow.AbstractWorkflowComponent;
import org.ametys.plugins.workflow.EnhancedCondition;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.parameter.ValidationResult;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class ValidateProgramItemTreeCondition
extends AbstractContentWorkflowComponent
implements EnhancedCondition {
    public static final String CHECK_TREE_KEY = "checkTree";
    protected ODFHelper _odfHelper;
    protected I18nUtils _i18nUtils;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._odfHelper = (ODFHelper)smanager.lookup(ODFHelper.ROLE);
        this._i18nUtils = (I18nUtils)smanager.lookup(I18nUtils.ROLE);
    }

    public boolean passesCondition(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        WorkflowAwareContent content;
        boolean checkTree = transientVars.getOrDefault(CHECK_TREE_KEY, true);
        if (checkTree && (content = this.getContent(transientVars)) instanceof ProgramItem) {
            ProgramItem programItem = (ProgramItem)content;
            return this._validateProgramItem(programItem, this.getConditionFailures(transientVars));
        }
        return true;
    }

    private boolean _validateProgramItem(ProgramItem programItem, List<AbstractWorkflowComponent.ConditionFailure> conditionFailures) {
        for (ProgramItem child : this._odfHelper.getChildProgramItems(programItem)) {
            ValidationResult validationResult = this._contentHelper.validateContent((Content)child);
            if (validationResult.hasErrors()) {
                if (conditionFailures != null) {
                    String errorMsg = validationResult.getErrors().stream().map(error -> this._i18nUtils.translate((I18nizable)error, "en")).collect(Collectors.joining(", "));
                    conditionFailures.add(new AbstractWorkflowComponent.ConditionFailure(errorMsg, ValidateProgramItemTreeCondition.class.getName()));
                }
                return false;
            }
            boolean isValid = this._validateProgramItem(child, conditionFailures);
            if (isValid) continue;
            return false;
        }
        return true;
    }

    public I18nizableText getLabel() {
        return new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_VALIDATE_PROGRAM_ITEM_TREE_CONDITION_LABEL");
    }
}

