/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Container actions
 * @private
 */
Ext.define('Ametys.plugins.odfpilotage.actions.ContainerActions', {
    singleton: true,
    
    /**
     * Action function to be called by the controller.
     * Will open the dialog box to edit MCC for a container
     * @param {Ametys.ribbon.element.ui.ButtonController} controller The controller calling this function
     */
    editMCCAttributes: function(controller)
    {
        var contentTarget = controller.getMatchingTargets()[0];
        var containerId = contentTarget.getParameters().id;
        Ametys.cms.content.ContentDAO.getContent(containerId, Ext.bind(this._editMCCAttributesCB, this));
    },
    
    _editMCCAttributesCB: function(content)
    {
        var openParams = {
            content: content,
            editWorkflowActionId: 2,
            workflowName: "container",
            viewName: "mcc"
        }
        
        Ametys.cms.uihelper.EditContent.open(openParams, null, this);
        
    }
});
